/* ***************************************************************************************
* FILE:          BlurShaderCustom.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BlurShaderCustom is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "widget2D_std_if.h"
#include "BlurShaderCustom.h"
#include <FeatStd/Diagnostics/Log.h>
#include <FeatStd/Util/Guid.h>


namespace hmibase {
namespace widget {
namespace blur {

using namespace Candera;

BlurShaderCustom::BlurShaderCustom()
{
   /* insert custom code here*/
}


SharedPointerShaderType BlurShaderCustom::GetShader()
{
   SharedPointerShaderType shader = Candera::Shader::Create();

   //BEGIN THIS NEEDS TO BE MODIFIED BY THE IMPLEMENTOR!
   shader->SetName("BlurShaderCustom"); //human readable name of the shader
   shader->SetGuid(FeatStd::Internal::Guid()); //empty and therefore invalid default (all zeros) guid
   //END   THIS NEEDS TO BE MODIFIED BY THE IMPLEMENTOR!

   /* insert custom code here*/

   return shader;
}


SharedPointerParamSetterType BlurShaderCustom::GetShaderParams()
{
   SharedPointerParamSetterType shaderParams = Candera::GenericShaderParamSetter::Create();

   /* insert custom code here*/

   return shaderParams;
}


bool BlurShaderCustom::HasValidShader()
{
   /* insert custom code here*/
   return false;
}


bool BlurShaderCustom::HasValidParams()
{
   /* insert custom code here*/
   return false;
}


void BlurShaderCustom::UpdateGuidString()
{
   BlurShaderBase::UpdateGuidString(); //update base class
   /************************************************************************/
   /*  add members content to m_guidstring here!                           */
   /*  m_guidString += m_xyz;                                              */
   /*  m_guidString += m_uvw;                                              */
   /************************************************************************/

   /* insert custom code here */
}


}
}


}   /* namespace */
