/* ***************************************************************************************
* FILE:          BlurRenderer.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BlurRenderer is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef BlurWidgetCommonSpace_BlurRenderer_h__
#define BlurWidgetCommonSpace_BlurRenderer_h__

#ifdef COURIER_ENHANCED_ENABLED

namespace hmibase {
namespace widget {
namespace blur {

/// @addtogroup COURIER_VISUALIZATION
/// @{

/** The Blur Renderer is responsible for maintaining the Gdu render objects which are loaded from the asset
   and created dynamically for blurring.
   */
class BlurRenderer : public Courier::Renderer
{
   public:
      BlurRenderer() {};
      virtual ~BlurRenderer() {};

      bool AddGdu(Candera::GraphicDeviceUnit* inGdu);
      bool LoadGdu(Candera::GraphicDeviceUnit* inGdu);
      bool RemoveGdu(Candera::GraphicDeviceUnit* inGdu);
};


}
}


}

#endif  //#ifdef COURIER_ENHANCED_ENABLED
#endif  // BlurWidgetCommonSpace_BlurRenderer_h__
