/* ***************************************************************************************
* FILE:          WidgetSetCore.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WidgetSetCore is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "WidgetSetCore.h"


WidgetSetEntryVectorType WidgetSetCore::_widgetSets;


void WidgetSetCore::RegisterWidgetSet(Candera::MetaInfo::WidgetSetMetaInfo* p)
{
   _widgetSets.push_back(p);
}


WidgetSetCore::WidgetSetCore() : Candera::MetaInfo::WidgetSetMetaInfo("WidgetSet")
{
   RegisterWidgetSets();
}


FeatStd::UInt WidgetSetCore::GetNumberOfWidgetSets() const
{
   return static_cast<FeatStd::UInt>(_widgetSets.size());
}


Candera::MetaInfo::WidgetSetMetaInfo* WidgetSetCore::GetWidgetSet(FeatStd::UInt index) const
{
   if (index < GetNumberOfWidgetSets())
   {
      Candera::MetaInfo::WidgetSetMetaInfo* p1 = _widgetSets.at(index);
      return p1;
   }
   return 0;
}


Candera::MetaInfo::WidgetMetaInfo* WidgetSetCore::LookupItem(const Candera::Char* name) const
{
   for (FeatStd::UInt i = 0; i < GetNumberOfWidgetSets(); ++i)
   {
      Candera::MetaInfo::WidgetSetMetaInfo* widgetSet = GetWidgetSet(i);
      if (0 != widgetSet)
      {
         Candera::MetaInfo::WidgetMetaInfo* widgetMetaInfo = widgetSet->LookupItem(name);
         if (0 != widgetMetaInfo)
         {
            return widgetMetaInfo;
         }
      }
   }
   return 0;
}


Candera::MetaInfo::WidgetMetaInfo* WidgetSetCore::GetItem(FeatStd::Int32 idx) const
{
   FeatStd::Int32 offset = 0;
   for (FeatStd::UInt i = 0; i < GetNumberOfWidgetSets(); ++i)
   {
      Candera::MetaInfo::WidgetSetMetaInfo* widgetSet = GetWidgetSet(i);
      if (0 != widgetSet)
      {
         FeatStd::Int32 count = widgetSet->GetItemCount();
         if (idx < offset + count)
         {
            return widgetSet->GetItem(idx - offset);
         }
         offset += count;
      }
   }
   return 0;
}


FeatStd::Int32 WidgetSetCore::GetItemCount() const
{
   FeatStd::Int32 count = 0;
   for (FeatStd::UInt i = 0; i < GetNumberOfWidgetSets(); ++i)
   {
      Candera::MetaInfo::WidgetSetMetaInfo* widgetSet = GetWidgetSet(i);
      if (0 != widgetSet)
      {
         count += widgetSet->GetItemCount();
      }
   }
   return count;
}


Candera::UInt32 WidgetSetCore::GetHash() const
{
   bool first = true;
   Candera::UInt32 hash = 0;
   for (FeatStd::UInt i = 0; i < GetNumberOfWidgetSets(); ++i)
   {
      Candera::MetaInfo::WidgetSetMetaInfo* widgetSet = GetWidgetSet(i);
      if (0 != widgetSet)
      {
         FeatStd::Int32 count = widgetSet->GetItemCount();
         for (int j = 0; j < count; ++j)
         {
            Candera::MetaInfo::WidgetMetaInfo* widgetMetaInfo = widgetSet->GetItem(j);
            if (0 != widgetMetaInfo)
            {
               const Candera::Char* name = widgetMetaInfo->GetName();
               if (0 != name)
               {
                  Candera::UInt32 currentHash = Candera::MetaInfo::Internal::Fnv1aHash::Hash(name);
                  if (first)
                  {
                     hash = currentHash;
                     first = false;
                  }
                  else
                  {
                     hash = Candera::MetaInfo::Internal::Fnv1aHash::MixHash(hash, currentHash);
                  }
               }
            }
         }
      }
   }
   return hash;
}


// Interface to WidgetFactory called from CGI framework
Candera::MetaInfo::WidgetSetMetaInfo* GetWidgetSet()
{
   static WidgetSetCore widgetSet;
   return &widgetSet;
}
