/* ***************************************************************************************
* FILE:          TraceQueryHelper.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TraceQueryHelper.h is part of HMI-Base widget Library
*    COPYRIGHT:  (c) 2015-2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_WIDGET_TRACE_TRACEQUERYHELPER_H
#define HMIBASE_WIDGET_TRACE_TRACEQUERYHELPER_H

#include "Trace/TraceQueryHelper.hpp"
#include "hmibase/util/Singleton.h"

namespace hmibase {
namespace widget {
namespace trace {

class TraceQueryHelper : public ::hmibase::trace::TraceQueryHelper::IWidgetTraceQueryHelper
{
   public:

      static TraceQueryHelper& GetInstance()
      {
         static TraceQueryHelper theInstance;
         return theInstance;
      }

      virtual ~TraceQueryHelper() {};

      virtual void ProcessQueryTraceMsgToPrintVisibleText(const QueryTraceInfoReqMsg& msg, ::Courier::View* view, std::string& printData);
      virtual bool ProcessSimTouchRequest(const SimTouchReqMsg& msg, ::Courier::IViewHandler& viewHandler, const ::hmibase::view::HMIRenderViewVisitor& hmiRenderViewVisitor);
      virtual bool ProcessTraceQueryRequest(const QueryTraceInfoReqMsg& msg, ::Courier::IViewHandler& viewHandler, const ::hmibase::view::HMIRenderViewVisitor& hmiRenderViewVisitor);
      virtual bool ProcessWidgetPropertySetRequest(const WidgetPropertySetterReqMsg& msg, ::Courier::IViewHandler& viewHandler, const ::hmibase::view::HMIRenderViewVisitor& hmiRenderViewVisitor);
      virtual void GetTextWidgetProperties(::Candera::Widget2D* widget, TextProperties&);
      virtual void ProcessQueryTraceMsgToGetPossibleTouchPoints(const QueryTraceInfoReqMsg& msg, Courier::IViewHandler& viewHandler, Courier::View* view, const ::hmibase::view::HMIRenderViewVisitor& hmiRenderViewVisitor);

      HMIBASE_UNCOPYABLE_CLASS(TraceQueryHelper)
};


}
}


}

#endif
