/* ***************************************************************************************
* FILE:          PrintTextInListCallback.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PrintTextInListCallback.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef PRINT_TEXT_IN_LIST_CALLBACK_H_
#define PRINT_TEXT_IN_LIST_CALLBACK_H_

#include "View/IMessageSystem.h"

namespace hmibase {
namespace widget {
namespace trace {
/** WidgetFinderCallback is used to get a callback from all the widgets in the current scene and
print their names.
*/
class PrintTextInListCallback : public WidgetCheckCallback
{
   public:
      /**
      Prints the widget name, based on the received input parameter (Candera::Widget2D*)
      */
      virtual bool CheckWidget(Candera::Widget2D* widget);

      PrintTextInListCallback(std::string* dataPtr)
      {
         _dataPtr = dataPtr;
      }

   private:
      std::string* _dataPtr;
};


}	// namespace_trace
}


}	// namespace_hmibase

#endif // PRINT_TEXT_IN_LIST_CALLBACK_H_
