/* ***************************************************************************************
* FILE:          ListWidgetFinderCallback.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListWidgetFinderCallback.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "sys_std_if.h"

#include "ListWidgetFinderCallback.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ListWidgetFinderCallback.cpp.trc.h"
#endif


namespace hmibase {
namespace widget {
namespace trace {
// ------------------------------------------------------------------------
ListWidgetFinderCallback::ListWidgetFinderCallback(const Courier::UInt32& listId) :
   _listId(listId)
   , _flexListWidget2DPtr(0)
{
}


// ------------------------------------------------------------------------
bool ListWidgetFinderCallback::CheckWidget(Candera::Widget2D* widgetPtr)
{
   if (widgetPtr != NULL)
   {
      ListWidget2D* listWidgetPtr = dynamic_cast <ListWidget2D*>(widgetPtr);
      if (listWidgetPtr != NULL)
      {
         if (listWidgetPtr->GetListId() == _listId)
         {
            ETG_TRACE_FATAL(("WidgetName = %100s of the type = %100s Found", listWidgetPtr->GetLegacyName(), listWidgetPtr->GetTypeName()));
            ETG_TRACE_FATAL(("ListId = %d", listWidgetPtr->GetListId()));
            _flexListWidget2DPtr = listWidgetPtr;
            return true;
         }
      }
   }
   return false;
}


} // namespace trace
}


}
