/* ***************************************************************************************
* FILE:          Touchable3D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Touchable3D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(Touchable3D_H)
#define Touchable3D_H

#include "Widgets/3D/BaseWidget3D.h"
#include "Courier/Visualization/IViewHandler.h"
#include "View/CGI/TouchHandling/TouchSession.h"


class Touchable3D : public BaseWidget3D
{
   public:
      Touchable3D();
      virtual ~Touchable3D();

      virtual bool IsTouchable() const
      {
         return true;
      }

      virtual void OnParentViewLoad(bool load);
      virtual void OnParentViewActivate(bool activate);
      virtual bool OnMessage(const Message& msg);
      virtual bool OnTouch(const Candera::Camera& camera3D, const Candera::Vector2& info, Courier::Float& dist);
      virtual bool OnTouchGeneric(const Candera::CanderaObject& camera, const Candera::Vector2& pos, FeatStd::Float dist = 0.0F);

      virtual bool processGestureEvent(const hmibase::input::gesture::GestureEvent& gestureData);
      virtual Gestures GetGestureList() const;
      virtual GesturePriorizationParameter getGesturePriorizationParameter() const;

      //Touchable property interface
      void SetTouchableStatus(const bool touchableStatus);
      bool GetTouchableStatus() const;

      typedef ::FeatStd::UInt32 TouchPriorityType;
      void SetTouchPriority(TouchPriorityType touchPriority);
      TouchPriorityType GetTouchPriority() const
      {
         return _touchPriority;
      }

      bool IsInsideBoundingRect(const Courier::TouchInfo& msg);
      CGI_WIDGET_RTTI_DECLARATION(Touchable3D, BaseWidget3D);

      // @WidgetBaseClass
      CdaWidgetDef(Touchable3D, BaseWidget3D)

      CdaDescription("Widget provides generic properties which each widget will be needing to perform a set of actions based on the properties and the same is a 2D widget")
      CdaCategory("")

      CdaProperties() //Start of Properties

      CdaProperty_ControllerId()
      CdaProperty_UserData()

      //Touchable Property
      CdaBindableProperty(Touchable, bool, GetTouchableStatus, SetTouchableStatus)
      CdaDescription("Widget is Touchable or not")
      CdaCategory("Common")
      CdaBindablePropertyEnd()

      CdaProperty(TouchPriority, TouchPriorityType, GetTouchPriority, SetTouchPriority)
      CdaDescription("Increase this priority to handle touch message for this widget before widgets with a lower priority")
      CdaCategory("Common")
      CdaVisibilityTest(GetTouchableStatus)
      CdaPropertyEnd()

      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      Courier::TouchInfo getCurrentSessionTouchInfo() const;
      Courier::TouchInfo getCurrentSessionStartTouchInfo() const;
      virtual void onTouchPress();
      virtual void onTouchRelease();
      void postTouchUpdMessage(hmibase::widget::enTouchState::Enum state);

   private:
      bool IsNodePicked(Candera::Camera* camera, Candera::Int16 x, Candera::Int16 y);

      bool _bIsTouchable;
      TouchPriorityType _touchPriority;
      hmibase::input::TouchSession* _touchSession;
};


namespace hmibase {
namespace widget {
typedef Touchable3D TouchableWidget3D;
}


}

#endif    // Touchable3D_H
