/* ***************************************************************************************
* FILE:          TextureImageWidget3D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TextureImageWidget3D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef __TEXTUREIMAGEWIDGET3D_H
#define __TEXTUREIMAGEWIDGET3D_H

#include "Widgets/3D/TextureImage/generated/TextureImageWidget3DBase.h"

class TextureImageWidget3D : public TextureImageWidget3DBase
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(TextureImageWidget3D, TextureImageWidget3DBase);
      TextureImageWidget3D();
      virtual ~TextureImageWidget3D();

      virtual void Update();
      virtual void OnNodeChanged();
      virtual void OnChanged(::Candera::UInt32 propertyId);

   private:

      bool _invalid;
      Candera::MemoryManagement::SharedPointer<Candera::BitmapTextureImage> _bitmapTextureImage;

      CdaWidgetDef(TextureImageWidget3D, TextureImageWidget3DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


#endif // __TEXTUREIMAGEWIDGET3D_H
