/* ***************************************************************************************
* FILE:          TextureImageWidget3D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TextureImageWidget3D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "CanderaPlatform/Device/Common/Effects/BitmapBrushBlend.h"
#include "TextureImageWidget3D.h"


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_IMAGE
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/TextureImageWidget3D.cpp.trc.h"
#endif


CGI_WIDGET_RTTI_DEFINITION(TextureImageWidget3D);


TextureImageWidget3D::TextureImageWidget3D(): Base(),
   _invalid(true)
{
}


TextureImageWidget3D::~TextureImageWidget3D()
{
}


void TextureImageWidget3D::OnChanged(::Candera::UInt32 propertyId)
{
   Base::OnChanged(propertyId);

   if (propertyId == BitmapPropertyId)
   {
      _invalid = true;
   }
}


void TextureImageWidget3D::OnNodeChanged()
{
   _invalid = true;
}


void TextureImageWidget3D::Update()
{
   Base::Update();

   while (_invalid)
   {
      if (GetNode() == 0)
      {
         ETG_TRACE_ERR_DCL((APP_TRACECLASS_ID(), "TextureImageWidget3D::No Node connected."));
         break;
      }

      BitmapType bitmap = GetBitmap();
      if (bitmap.PointsToNull())
      {
         ETG_TRACE_ERR_DCL((APP_TRACECLASS_ID(), "TextureImageWidget3D::No bitmap."));
         break;
      }
      if (_bitmapTextureImage.PointsToNull())
      {
         _bitmapTextureImage = Candera::BitmapTextureImage::Create();
      }
      HMI_APP_ASSERT(_bitmapTextureImage != 0);

      if (_bitmapTextureImage.PointsToNull())
      {
         break;
      }
      _bitmapTextureImage->SetBitmap(bitmap);

      Candera::MemoryManagement::SharedPointer<Candera::Texture> texture = Candera::Texture::Create();
      if (texture.PointsToNull())
      {
         break;
      }
      texture->SetTextureImage(_bitmapTextureImage);
      Candera::MemoryManagement::SharedPointer<Candera::Appearance> app = GetNode()->GetAppearance();
      if (app.PointsToNull())
      {
         ETG_TRACE_ERR_DCL((APP_TRACECLASS_ID(), "TextureImageWidget3D:: Appearance failed"));
         break;
      }
      app->SetTexture(texture);
      if (!texture->Upload())
      {
         ETG_TRACE_ERR_DCL((APP_TRACECLASS_ID(), "TextureImageWidget3D:: Upload failed"));
         break;
      }
      _invalid = false;
      Invalidate();
   }
   if (_invalid)
   {
      ETG_TRACE_ERR_DCL((APP_TRACECLASS_ID(), "TextureImageWidget3D::Failed to upload texture."));
   }
}
