/* ***************************************************************************************
* FILE:          NodeSelector.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  NodeSelector is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(NODESELECTOR_H)
#define NODESELECTOR_H

#include <Candera/Candera.h>

/**
* Allows Nodes to be selected using screen coordinates.
*/
class NodeSelector
{
   public:
      enum SelectionMode
      {
         GeometryLineTest,
         BoundingSphereLineTest,
         GeometryPickTest,
         SelectionNone
      };

      static SelectionMode GetSelectionMode()
      {
         return m_selectionMode;
      }
      static void SetSelectionMode(SelectionMode mode)
      {
         m_selectionMode = mode;
      }

      /**
       * Retrieves the nearest Node on the given screen coordinates
       * @param x       X-coordinate on the screen.
       * @param y       Y-coordinate on the screen.
       * @return  Pointer to selected Node, or null if there is selected Node
       */

#ifdef CANDERA_3D_ENABLED
      static Candera::Node* SelectNode(Candera::Node* node, Candera::Camera* camera, Candera::Int16 x, Candera::Int16 y, Candera::ScopeMask sm, bool includeChildNodes);
#endif

#ifdef CANDERA_2D_ENABLED
      static Candera::Node2D* SelectNode2D(Candera::Node2D* node, Candera::Camera2D* camera, Candera::Int16 x, Candera::Int16 y, Candera::ScopeMask sm, bool includeChildNodes);
#endif

   private:
      static SelectionMode m_selectionMode;

      NodeSelector() { }
      ~NodeSelector() { }

#ifdef CANDERA_3D_ENABLED
      static void SelectNodeRecursive(Candera::Camera* camera, Candera::Node* node, Candera::Node** nearestNode, Candera::Float* minDistance, Candera::Int16 x, Candera::Int16 y, Candera::ScopeMask sm, bool includeChildNodes);
#endif

#ifdef CANDERA_2D_ENABLED
      static void SelectNodeRecursive2D(Candera::Camera2D* camera, Candera::Node2D* node, Candera::Node2D** nearestNode, Candera::Float* minDistance, Candera::Int16 x, Candera::Int16 y, Candera::ScopeMask sm, bool includeChildNodes);
#endif
};


#endif    // NODESELECTOR_H
