/* ***************************************************************************************
* FILE:          MultiSliderHelperWidget3D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MultiSliderHelperWidget3D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef MultiSliderHelperWidget3D_h
#define MultiSliderHelperWidget3D_h

#include <Widgets/3D/MultiSliderHelper/generated/MultiSliderHelperWidget3DBase.h>
#include <CanderaAssetLoader/AssetLoaderBase/ArrayDataType.h>

namespace Courier {
namespace TouchHandling {
class TouchSessionStartEvent;
}


}

class MultiSliderHelperWidget3D : public MultiSliderHelperWidget3DBase
{
   public:
      typedef Candera::ArrayProperty<FeatStd::Float> ValueArrayProperty;

      MultiSliderHelperWidget3D();
      virtual ~MultiSliderHelperWidget3D();

      CGI_WIDGET_RTTI_DECLARATION(MultiSliderHelperWidget3D, MultiSliderHelperWidget3DBase);

      CdaWidgetDef(MultiSliderHelperWidget3D, MultiSliderHelperWidget3DBase)
      CdaDescription("Implementation of MultiSliderHelperWidget3D")
      CdaReadableName("MultiSliderHelperWidget3D")
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

      void UpdateValues(const ValueArrayProperty& valueArray);

   protected:
      virtual void Update() override;
      virtual void OnChanged(::FeatStd::UInt32 propertyId) override;
      virtual void OnNodeChanged() override;

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(MultiSliderHelperWidget3D);

      struct GeometryData
      {
         Candera::Vector3 m_pos;
         Candera::Vector2 m_texCoord;

         GeometryData() {}
         GeometryData(const Candera::Vector3& pos, const Candera::Vector2& texCoord) : m_pos(pos), m_texCoord(texCoord) {}
      };

      struct Billboard
      {
         enum
         {
            c_vertexCount = 5,
            c_indexCount = 3 * (c_vertexCount - 1)
         };

         static const FeatStd::UInt16 c_index[c_indexCount];
         GeometryData m_geometry[c_vertexCount];

         Billboard();
         void Move(FeatStd::Float x, FeatStd::Float y);
         void Rotate(FeatStd::Float angle);
         void SetGeometry(FeatStd::SizeType index, FeatStd::Float x, FeatStd::Float y);
      };

      static void DisposeBillboards(const void* ptr);
      static void DisposeIndizes(const void* indizes);
      static void SetIndizes(FeatStd::SizeType billboardIndex, FeatStd::UInt16* index);
      static Candera::Color Mix(const Candera::Color& color1, const Candera::Color& color2, FeatStd::Float value);

      bool m_createVertexBuffer;
      bool m_reCalculate;
      FeatStd::Float m_f;
      Candera::VertexBuffer::SharedPointer m_vertexBuffer;
      ValueArrayProperty m_valueArray;

      Candera::VertexBuffer::SharedPointer CreateVertexBuffer();
      void UpdateMesh();
      void ReCalculate();
      void UpdateColor(const Candera::Vector2& center);
      Candera::Mesh* GetMesh() const
      {
         return Candera::Dynamic_Cast<Candera::Mesh*>(GetNode());
      }
      FeatStd::Float CalculateValue(const FeatStd::Float value) const;
};


#endif  // MultiSliderHelperWidget3D_h
