/* ***************************************************************************************
* FILE:          DirectTextureProvider3D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DirectTextureProvider3D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(_DirectTextureProvider3D_H)
#define _DirectTextureProvider3D_H

#include <Candera/Environment.h>
#include "Widgets/3D/BaseWidget3D.h"
#include <CanderaPlatform/Device/Common/Base/DirectTextureImage.h>
#include <CanderaPlatform/Device/Common/Base/GraphicDeviceUnit.h>
//#include <CanderaPlatform/Device/iMX6/iMX6FrameBufferObject.h>
#include <CanderaPlatform/Device/Genivi/GeniviFrameBufferObject.h>

#include <CanderaPlatform/Device/Common/OpenGLES/GlTraceMapper.h>

namespace hmibase {
namespace gadget {
namespace videobuffer {
class VideoBufferType;
} // namespace
} // namespace
} // namespace

class DirectTextureProvider3D : public BaseWidget3D
{
   public:

      DirectTextureProvider3D();
      virtual ~DirectTextureProvider3D();

      CGI_WIDGET_RTTI_DECLARATION(DirectTextureProvider3D, BaseWidget3D);

      virtual void Init(Candera::AssetProvider* assetProvider);
      virtual void Update();

      virtual bool IsVirtuallyTouched(FeatStd::UInt32 /*instanceId*/)
      {
         // to be changed if widget supports instance identifier (like in 2D)
         return false;
         //return (GetInstanceId() == instanceId);
      }

      void SetGraphicDeviceUnit(Candera::GraphicDeviceUnit* gdu)
      {
         m_gdu = gdu;
      }
      Candera::GraphicDeviceUnit* GetGraphicDeviceUnit() const
      {
         return m_gdu;
      }

      void SetCamera(Candera::Node* camera)
      {
         m_camera = camera;
      }
      Candera::Node* GetCamera() const
      {
         return m_camera;
      }

      CdaWidgetDef(DirectTextureProvider3D, BaseWidget3D)
      CdaDescription("Direct Texture Widget")
      CdaReadableName("DirectTextureProvider3D")
      CdaCategory("Examples")

      CdaProperties()

      CdaProperty(Camera, Candera::Node*, GetCamera, SetCamera)
      CdaDescription("Camera used for intersection test.")
      CdaPropertyEnd()

      CdaProperty(FrameBuffer, Candera::GraphicDeviceUnit*, GetGraphicDeviceUnit, SetGraphicDeviceUnit)
      CdaDescription("Frame buffer object")
      CdaCategory("RenderTarget")
      CdaPropertyEnd()

      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   private:
      Candera::MemoryManagement::SharedPointer<Candera::DirectTextureImage> m_directTextureImage;
      Candera::MemoryManagement::SharedPointer<Candera::Texture> m_texture;
      Candera::GraphicDeviceUnit* m_gdu;
      bool m_invalidated;
      Candera::Node* m_camera;
      hmibase::gadget::videobuffer::VideoBufferType* m_drmBuffer;

      /**
       *  unload and upload the fbo.
       */
      bool Upload();
};


#endif // _DirectTextureProvider3D_H
