/* ***************************************************************************************
* FILE:          SimpleButtonWidget3D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SimpleButtonWidget3D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(CANDERA_SimpleButtonWidget_H)
#define CANDERA_SimpleButtonWidget_H

#include <CanderaWidget/Widget.h>
#include <CanderaWidget/Widget3D/WidgetDataTypes.h>
#include <Candera/Engine3D/Core/VertexGeometryBuilder.h>
#include <Widgets/generated/AllWidgetTypes.h>
#include <Widgets/generated/AllWidgetMessages.h>
#include <Widgets/3D/Button/generated/SimpleButtonWidget3DBase.h>

class SimpleButtonWidget3D : public SimpleButtonWidget3DBase
{
   public:
      SimpleButtonWidget3D();
      virtual ~SimpleButtonWidget3D();

      CGI_WIDGET_RTTI_DECLARATION(SimpleButtonWidget3D, SimpleButtonWidget3DBase);

      virtual void Init(Candera::AssetProvider* assetProvider);
      virtual void OnChanged(::Candera::UInt32 propertyId);
      virtual void Update();

   protected:
      virtual void OnNodeChanged();
      virtual void onTouchPress();
      virtual void onTouchRelease();

   private:
      void postReactionMsg(enReaction reaction);

      bool _invalid;

      CdaWidgetDef(SimpleButtonWidget3D, SimpleButtonWidget3DBase);
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


//}
#endif    // CANDERA_SimpleButtonWidget_H
