/* ***************************************************************************************
* FILE:          BaseWidget3D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BaseWidget3D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(BaseWidget3D_H)
#define BaseWidget3D_H

#include "Courier/Version.h"
#include "CanderaWidget/Widget.h"
#include "Courier/DataBinding/DataBinding.h"

#include <Widgets/generated/AllWidgetTypes.h>
#include <Widgets/generated/AllWidgetMessages.h>

/**
 * base class for 3D widgets
 */
class BaseWidget3D : public Candera::Widget
{
   public:
      BaseWidget3D();
      virtual ~BaseWidget3D();

      CGI_WIDGET_RTTI_DECLARATION(BaseWidget3D, Candera::Widget);

      // prevents the dynamic cast
      virtual const BaseWidget3D* ToBaseWidget3D() const
      {
         return this;
      }

      // prevents the dynamic cast
      virtual BaseWidget3D* ToBaseWidget3D()
      {
         return this;
      }

      //returns false because this is a not 2D widget
      virtual bool Is2D() const
      {
         return false;
      }

      //returns NULL because this is not a 2D widget
      virtual Candera::Node2D* GetNode2D() const
      {
         return NULL;
      }

      //returns true because this is a 3D widget
      virtual bool Is3D() const
      {
         return true;
      }

      //returns the node associated with this 3D widget
      virtual Candera::Node* GetNode3D() const
      {
         return GetNode();
      }

      virtual void Init(Candera::AssetProvider* assetFactory);

      virtual bool IsEffectiveVisible() const;

      virtual void OnSceneShown() {};

      /// Return the Name of a Widget as it used to be in Candera 2.x even if Candera 3.x is used. - COPY FROM BaseWidget2D
      const FeatStd::Char* GetLegacyName();

      // @WidgetBaseClass
      CdaWidgetDef(BaseWidget3D, Candera::Widget)
      CdaProperties()

      CdaProperty(Enabled, bool, IsEnabled, SetEnabled)
      CdaDescription("Enabled: Enable or disable the widget")
      CdaPropertyEnd()

      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      Candera::AssetProvider* GetAssetProvider()
      {
         return m_assetProvider;
      }

   private:
      //Init member _legacyName with fully qualified name as provided by GetName with Candera v2.xx
      void InitLegacyName();

      //Init member _cachedStringIdentifier as a copy of the GetStringId hierarchy with the original string pointers.
      void InitCachedStringIdentifier();
      //Cleanup member _cachedStringIdentifier
      void CleanupCachedStringIdentifier();

      Candera::AssetProvider* m_assetProvider;

      std::string _legacyName;
      const FeatStd::Char* _cachedName;
      const Candera::StringIdentifier* _cachedStringIdentifier; //Holds a deep clone of the StringIdentifier hierarchy of this widget.
};


#endif    // BaseWidget3D_H
