/* ***************************************************************************************
* FILE:          HanWang_Interface.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HanWang_Interface is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef _HANWANG_INTERFACE_H
#define _HANWANG_INTERFACE_H

#include "HWAPI.h"
#include "HWLANG.h"

class HanWangInterface
{
   public:

      HanWangInterface(
         FeatStd::Int32 dwCurrentLanguage,
         FeatStd::UInt32 dwRange,
         const FeatStd::Char* pcCharRecDictionaryPath,
         const FeatStd::Char* pcWordRecDictionaryPath,
         int modePriority
      );
      ~HanWangInterface();

      bool initialize();
      void setDictionaryRootPath(const char* path)
      {
         _dictionaryRootPath = path;
      }
      int recognizeCharacters(short* points, FeatStd::UInt16* result) const;
      int predictWords(const unsigned short* predictHint, FeatStd::UInt16* result);

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(HanWangInterface);

      FeatStd::UInt8* loadDictionaryPointer(const FeatStd::Char*);

      Candera::UInt8*         _characterRecDicRom;    //< pointer to character recgonization dictionary
      Candera::UInt8*         _wordRecDicRom;         //< pointer to character recgonization dictionary
      long                    _ram[HWRERAMSIZE / 4];  //< acquire RAM for recognition engine,in Four-byte alignment
      THWAttribute*           _attribute;            //< attributes for detection.
      Candera::UInt32         _dwRange;
      Candera::Int32          _dwLanguage;
      const Candera::Char*    _charRecDictionaryPath;
      const Candera::Char*    _wordRecDictionaryPath;
      int                     _priorityMode;
      std::string             _dictionaryRootPath;
};


#endif // _HanWangInterface_H
