/* ***************************************************************************************
* FILE:          HandWritingWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HWRBackendInterface.cpp part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015 Robert Bosch Car Multimedia GmbH
*
*  This software is part of the Bosch Widget Library and property of Robert Bosch GmbH.
*  Unauthorized duplication and disclosure to third parties is prohibited.
*  All rights reserved.
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "HWRBackendInterface.h"


HWRBackendInterface::HWRBackendInterface()
#if defined(CANDERA_META_DESCRIPTION)
   : _strArray()
#endif
{
}


HWRBackendInterface::~HWRBackendInterface()
{
}


void HWRBackendInterface::setString(::std::string strtoStore)
{
   _strArray.push_back(strtoStore);
}


::std::string HWRBackendInterface::getString(FeatStd::UInt8 predictedWordAtIndex)
{
   ::std::string retStr;

   if (predictedWordAtIndex < _strArray.size())
   {
      retStr = _strArray[predictedWordAtIndex];
   }
   return retStr;
}


FeatStd::UInt32 HWRBackendInterface::numberOfPredictedWords() const
{
   return static_cast<FeatStd::UInt32>(_strArray.size());
}


FeatStd::MemoryManagement::SharedPointer<HWRBackendInterface> HWRBackendInterface::pCreate()
{
   return FeatStd::MemoryManagement::SharedPointer<HWRBackendInterface>(FEATSTD_NEW(HWRBackendInterface)());
}
