#ifndef __HWAPI_H
#define __HWAPI_H

#define HANWANG_INTEGRATED_DICT            0// 
/* -------------------Range of GB18030------------------------ */
#define GB_ALC_SC_COMMON            0x00000001        /* Simplified Chinese:GB2312 Level1 */
#define GB_ALC_SC_RARE                0x00000002        /* Simplified Chinese:GB2312 Level2 */
#define GB_ALC_TC_COMMON            0x00000004        /* Traditional Chinese Level1 */
#define GB_ALC_TC_RARE                0x00000008        /* Traditional Chinese Level2*/
#define GB_ALC_SC_GBK34            0x00000010        /* GBK34 other*/
#define GB_ALC_SC_GB18030EX    0x00000020      /* GB18030 ext 6530 */
#define GB_ALC_GBK             0x0000001F     /*GB_ALC_SC_COMMON|GB_ALC_SC_RARE|GB_ALC_TC_COMMON|GB_ALC_TC_RARE|GB_ALC_SC_GBK34*/
#define GB_ALC_GB18030         0x0000003F      /* GB18030 *//*GB_ALC_GBK|GB_ALC_SC_GB18030EX*/
#define GB_ALC_TC_TO_SC        0x00000040    /*recognize traditional Chinese convert to Simplified Chinese */
#define GB_ALC_CS_CURSIVE      0x00000080      /* cursive */
#define GB_ALC_NUMERIC                0x00000100        /*  0-9  */
#define GB_ALC_LCALPHA              0x00000200        /* small letter( form a to z ) */
#define GB_ALC_UCALPHA                0x00000400        /* capital letter( from A to Z ) */
#define GB_ALC_SYMBOL              0x00000800        /* symbols */
#define GB_ALC_HIRAGANA        0x00001000
#define GB_ALC_KATAKANA        0x00002000
#define GB_ALC_SC_RADICAL      0x00004000    /*RADICAL */
#define    GB_ALC_GESTURE                0x00040000    /*GESTURE*/
#define GB_ALC_VALID                  0x00FFFFFF        /* valid range */

/* -------------------Range 0f Big5HK------------------------ */
#define BI_ALC_TC_COMMON            0x00000001        /* Traditional character level1 */
#define BI_ALC_TC_RARE                0x00000002        /* Traditional character level2 */
#define BI_ALC_SC_TO_TC            0x00000010         /*recognize Simplified Chinese convert to traditional Chinese */
#define BI_ALC_TC_HK                  0x00000020        /* HK2004-ISO2000 */
#define BI_ALC_NUMERIC                0x00000100        /*  0-9  */
#define BI_ALC_LCALPHA              0x00000200        /* small letter( form a to z ) */
#define BI_ALC_UCALPHA                0x00000400        /* capital letter( from A to Z ) */
#define BI_ALC_SYMBOL              0x00000800        /* symbols */
#define BI_ALC_HIRAGANA        0x00001000
#define BI_ALC_KATAKANA        0x00002000
#define BI_ALC_CS_BOPOMOFO     0x00004000      /* zhuyin   */
#define BI_ALC_CS_CURSIVE      0x00008000      /* cursive */
#define    BI_ALC_GESTURE                0x00040000    /*GESTURE*/
#define BI_ALC_VALID                  0x00FFFFFF        /* valid range */

/* -------------------Range of Japan------------------------ */
#define JAPAN_ALC_ADOBE1_0            0x00000001
#define JAPAN_ALC_ADOBE1_2            0x00000002
#define JAPAN_ALC_ADOBE1_4            0x00000004
#define JAPAN_ALC_NUMERIC             0x00000008
#define JAPAN_ALC_LCALPHA             0x00000010
#define JAPAN_ALC_UCALPHA             0x00000020
#define JAPAN_ALC_HIRAGANA            0x00000040
#define JAPAN_ALC_KATAKANA            0x00000080
#define JAPAN_ALC_SYMBOL              0x00000100
#define JAPAN_ALC_GESTURE             0x00040000
#define JAPAN_ALC_VALID                  0x00FFFFFF        /* valid range */

/* -------------------Range of Korea------------------------ */
#define KOREA_ALC_KSX_HANGUL        0x00000001        /* Hangul */
#define KOREA_ALC_KSX_JAMO            0x00000002        /* Jamo letter */
#define KOREA_ALC_KSX_HANJA            0x00000004        /* Hanja */
#define KOREA_ALC_NUMERIC            0x00000010        /*  0-9  */
#define KOREA_ALC_UCALPHA              0x00000020        /* capital letter( form A to Z) */
#define KOREA_ALC_LCALPHA            0x00000040        /* small letter( from a to z ) */
#define KOREA_ALC_HIRAGANA          0x00000100
#define KOREA_ALC_KATAKANA          0x00000200
#define KOREA_ALC_SYMBOL              0x00000400        /* Symbols */
#define    KOREA_ALC_GESTURE            0x00040000    /*GESTURE*/
#define KOREA_ALC_VALID                0x000FFFFF        /* valid range */

/* -------------------Range of Arabic------------------------ */
#define AR_ALC_ARABIC_BASIC       0x00000001
#define AR_ALC_ARABIC_NUM         0x00000002
#define AR_ALC_ARABIC_SYMBOL      0x00000004
#define AR_ALC_NUMERIC            0x00000008
#define AR_ALC_LOWER_ENG          0x00000010
#define AR_ALC_UPPER_ENG          0x00000020
#define AR_ALC_SYMBOL             0x00000040
#define AR_ALC_GESTURE            0x00040000
#define AR_ALC_VALID                    0x000FFFFF        /* valid range */

/* -------------------Range of Europ ------------------------ */
#define EUR_ALC_LATIN_LOWERCASE                0x00000001    // lower Latin letters
#define EUR_ALC_LATIN_UPPERCASE                0x00000002    // upper Latin letters
#define EUR_ALC_CYRILLIC_LOWERCASE            0x00000004    // lower Russian letters
#define EUR_ALC_CYRILLIC_UPPERCASE            0x00000008    // upper Russian letters
#define EUR_ALC_GREEK_LOWERCASE                0x00000010    // lower Greek letters
#define EUR_ALC_GREEK_UPPERCASE                0x00000020  // upper Greek letters
#define EUR_ALC_NUMERIC                        0x00010000    // NUM
#define EUR_ALC_SYMBOL                        0x00020000    // SYMBOL
#define EUR_ALC_GESTURE                        0x00040000    // GES

/* ------------------Range of Thai---------------------- */
#define THAI_ALC_THAICON            0x00000001     // Thai Consonant 
#define THAI_ALC_THAIVOW            0x00000002     // Thai Vowel 
#define THAI_ALC_THAISIGN            0x00000004     // Thai Sign     
#define THAI_ALC_THAIDIGI            0x00000008     // Thai Digit   
#define THAI_ALC_THAITONE            0x00000010     // Thai ToneMark  
#define THAI_ALC_THAICUR            0x00000020     // Thai Currency    
#define THAI_ALC_NUMERIC            0x00000040        //Number ( 0-9 )
#define THAI_ALC_LCALPHA            0x00000100        //Lowercase Latin characters ( a-z )
#define THAI_ALC_UCALPHA            0x00000200        //Uppercase Latin characters ( A-Z )                                             
#define THAI_ALC_SYMBOL              0x00000400      // Symbols                                               
#define    THAI_ALC_GESTURE            0x00040000        // Control gesture

//---------------Const----------------------------
#define MAXCANDNUM                10            // max num of candidate
#define HWRERAMSIZE                (40*1024)    // RAM size

#define HWLANG_Simp_Chinese     0x1000
#define HWLANG_Trad_Chinese     0x1010

/* ----------------priority mode-------------------------- */
#define NUMBER_FIRST_MODE       1         //Num priority mode
#define LETTERS_FIRST_MODE      2         //Character priority mode
#define LETTERS_NUM_MODE        3         //Character  first and Num Second of the first two or first three candidates  
#define FREETEXT_MODE           0         //Freetext mode

/* ------------stroke------------------- */
#define STROKEENDMARK            (-1)        // flag of end stroke

typedef struct tagTHWPoint
{
   short x; //
   short y; //
} THWPoint;

typedef struct tagTHWFrame
{
   short left;        // X Position of top left corner
   short top;         // Y Position of top left corner
   short width;       // the width of writing frame
   short height;      // the heighth of writing frame
} THWFrame;
/* ------------Attribute------------------ */
typedef struct tagTHWAttribute
{
   unsigned long     dwLanguage;//Language set -1(except Europ language)
   int                iCandidateNum;    // num of Candidate
   unsigned long    dwRange;        // Range
   unsigned char*    pRam;            // RAM
   unsigned char*    pRom;            // Dic
   unsigned long   dwSlantRange;     //
   //
   // dwSlantRange 0 ~ 180
   // 0   without slant

   unsigned short    wMode;           // priority  mode
   THWFrame*         pFrame;    // Frame for writing
} THWAttribute;

#ifdef __cplusplus
extern "C" {
#endif

/*
functionRecognize
parameter
    pTraceformat is (x1,y1),(x2,y2),...,(STROKEENDMARK,0),...,
            (STROKEENDMARK,0),(STROKEENDMARK,STROKEENDMARK)
            and (STROKEENDMARK,0)is flag of end stroke
            (STROKEENDMARK,STROKEENDMARK)is flag of character
    pAttrAttribute for Recognize
    pResultRecognize Result(the first Candidate+Score + the second Candidate+Score  + ...)

    iThreshold:the Threshold for Score (0-100),eg: if set the threshold is 60,then out put  the candidate num <= iCandidateNum,and score of the candidate >=60
return
         =-1:the engin can not recognize the trace
      =-3:input wrong parameters or wrong dic
    = 0:without candidata
    > 0:num of Candidate
*/

int HWRecognize(const THWPoint* pTrace, const THWAttribute* pAttr, unsigned short* pResult, unsigned short iThreshold);

/*
functionRecognize
parameter
    pTraceformat is (x1,y1),(x2,y2),...,(STROKEENDMARK,0),...,
            (STROKEENDMARK,0),(STROKEENDMARK,STROKEENDMARK)
            and (STROKEENDMARK,0)is flag of end stroke
            (STROKEENDMARK,STROKEENDMARK)is flag of character
    pAttrAttribute for Recognize
    pResultRecognize Result( in UTF-8)
    pScore:the score of every candidate ,from high to low

    iThreshold:the Threshold for Score (0-100),eg: if set the threshold is 60,then out put  the candidate num <= iCandidateNum,and score of the candidate >=60
return
  =-1: the engin can not recognize the trace
  =-3:input wrong parameters,or wrong dic
    = 0:without candidate
    > 0:num of Candidate
*/
int HWRecognize_UTF8(const THWPoint* pTrace, const THWAttribute* pAttr, unsigned char* pResult, unsigned char* pScore, unsigned short iThreshold);
/*
˵Ԥ
pszWordԤĹؼ
pSystemDictԤʱʹõϵͳֵ䣬ӢֱΪChsSysDic.dicChtSysDic.dic
pSuggestԤ,ѡԡ0ָ
iBufSizeԤĴС
wLanguageԤԵãȡϵͳֵƥ
*/
int HWIM_PredictText(const unsigned short* pszWord,
                     const unsigned char* pSystemDict,
                     unsigned short* pSuggest, int iBufSize, unsigned short wLanguage);
#ifdef __cplusplus
}


#endif

#endif
