/* ***************************************************************************************
* FILE:          WidgetSet2DStandard.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WidgetSet2DStandard is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
//lint -emacro({665}, _CdaStaticAggregation)
//lint -emacro({446}, _CdaStaticAggregation)

#include "View/CGI/CgiExtensions/AppViewHandler.h"
#include "View/CGI/CgiExtensions/ViewControllerBase.h"
#include <View/CGI/CgiExtensions/ViewFactory.h>

#include "Widgets/2D/List/ListPrioWidgetComparator.h"
#include "Widgets/2D/DragDrop/DDManager.h"
#include "Widgets/2D/List/Data/AppListDataProviderCache.h"
#include "Widgets/utils/WindowInputEventHook.h"
#include "Widgets/Trace/TraceQueryHelper.h"

#include "Widgets/WidgetSetCore.h"

#include "Widgets/2D/Animation/AnimationWidget2D.h"
#include "Widgets/2D/AnimationControl/AnimationControlWidget2D.h"
#include "Widgets/2D/StepAnimation/StepAnimationWidget2D.h"
#include "Widgets/2D/Blur/BlurWidget2D.h"
#include "Widgets/2D/Button/ButtonWidget2D.h"
#include "Widgets/2D/ButtonAnimation/ButtonAnimationWidget2D.h"
#include "Widgets/2D/ButtonGroup/ButtonGroupWidget2D.h"
#include "Widgets/2D/ButtonImage/ButtonImageWidget2D.h"
#include "Widgets/2D/ButtonText/ButtonTextColorWidget2D.h"
#include "Widgets/2D/ButtonText/ButtonTextScrollWidget2D.h"
#include "Widgets/2D/CameraControl/CameraControlWidget2D.h"
#include <Widgets/2D/ColorSwitch/ColorSwitchWidget2D.h>
#include "Widgets/2D/ComboBox/ComboBoxWidget2D.h"
#include "Widgets/2D/Delegate/DelegateWidget2D.h"
#include "Widgets/2D/TextBaseLineOffset/TextBaseLineOffsetWidget2D.h"
#include "Widgets/2D/TextColor/TextColorWidget2D.h"
#include "Widgets/2D/TextExtension/TextExtensionWidget2D.h"
#include "Widgets/2D/GridAutoArrange/GridAutoArrangeWidget2D.h"
#include "Widgets/2D/EditField/EditFieldWidget2D.h"
#include "Widgets/2D/EffectControl/ColorEffectWidget2D.h"
#include <Widgets/2D/EffectControl/EffectControlWidget2D.h>
#include "Widgets/2D/Focus/FocusGroupWidget2D.h"
#include "Widgets/2D/Gesture/GestureWidget2D.h"
#include "Widgets/2D/Gizmo/GizmoWidget2D.h"
#include "Widgets/2D/ImageSwitch/ImageSwitchWidget2D.h"
#include "Widgets/2D/ImageEffect/ImageEffectWidget2D.h"
#include "Widgets/2D/Marker/MarkerWidget2D.h"
#include <Widgets/2D/Mesh/MeshWidget2D.h>
#include <Widgets/2D/MultiSlider/MultiSliderWidget2D.h>
#include "Widgets/2D/NodeControl/NodeControlWidget2D.h"
#include "Widgets/2D/PanelSlide/PanelSlideWidget2D.h"
#include "Widgets/2D/ProgressBar/ProgressBarWidget2D.h"
#include "Widgets/2D/Scope/ScopeWidget2D.h"
#include "Widgets/2D/Slider/SliderWidget2D.h"
#include "Widgets/2D/Slider/AngularSliderWidget2D.h"
#include "Widgets/2D/SolidColorEffect/SolidColorEffectWidget2D.h"
#include "Widgets/2D/Speller/SpellerWidget2D.h"
#include "Widgets/2D/SurfaceInputRegion/SurfaceInputRegionWidget2D.h"
#include "Widgets/2D/Text/TextWidget2D.h"
#include <Widgets/2D/TextHighlight/TextHighlightWidget2D.h>
#include "Widgets/2D/Label/LabelWidget2D.h"
#include "Widgets/2D/Layout/MarginWidget2D.h"
#include "Widgets/2D/TimerWidget/TimerWidget2D.h"
#include "Widgets/2D/TextArea/TextAreaWidget2D.h"
#include "Widgets/2D/ScrollableText/ScrollableTextWidget2D.h"
#include "Widgets/2D/MeterWidget/MeterWidget2D.h"
#include "Widgets/2D/DirectTextureProvider/DirectTextureProvider2D.h"
#include "Widgets/2D/DirectTextureConsumer/DirectTextureConsumer2D.h"
#include "Widgets/2D/Clock/ClockWidget2D.h"
#include "Widgets/2D/OPS/OPSWidget2D.h"
#include "Widgets/2D/TwoDimensionSlider/TwoDimensionSliderWidget2D.h"
#include "Widgets/2D/TextWaitAnimation/TextWaitAnimationWidget2D.h"
#include "Widgets/2D/ColorBar/ColorBarWidget2D.h"
#include <Widgets/2D/List/ListWidget2D.h>
#include <Widgets/2D/ScrollBar/ScrollBarWidget2D.h>
#include <Widgets/2D/OffscreenTouchProxy/OffscreenTouchProxyWidget2D.h>
#include <Widgets/2D/PageEdit/PageEditWidget2D.h>
#include <Widgets/2D/ViewSwitch/ViewSwitchWidget2D.h>

#ifdef VARIANT_S_FTR_ENABLE_RICH_TEXT_WIDGET
#include <Widgets/2D/RichText/RichTextHighlightWidget2D.h>
#include <Widgets/2D/RichText/RichTextMarqueeWidget2D.h>
#include <Widgets/2D/RichText/RichTextWidget2D.h>
#include <Widgets/2D/RichText/ScrollableRichTextWidget2D.h>
#endif

#if defined SESA_ARABIC_LAYOUT_FIX
#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include "Candera/EngineBase/Layout/ArabicLayouterPatch.h"
#else
#include "Candera/Engine2D/Layout/ArabicLayouterPatch.h"
#endif
#endif

CdaWidgetSetPartDefinitionBegin(WidgetSet2DStandard)
CdaDescription("HMI-Base Widget Set Standard")
CdaVersion(HMI_BASE_WIDGET_VERION)
CdaWidgets()
CdaWidget(AnimationWidget2D)
CdaWidget(hmibase::widget::animation::AnimationControlWidget2D)
CdaWidget(StepAnimationWidget2D)
CdaWidget(FocusGroupWidget2D)
CdaWidget(hmibase::widget::blur::BlurWidget2D)
CdaWidget(ButtonWidget2D)
CdaWidget(ButtonAnimationWidget2D)
CdaWidget(ButtonGroupWidget2D)
CdaWidget(ButtonImageWidget2D)
CdaWidget(ButtonTextColorWidget2D)
CdaWidget(ButtonTextScrollWidget2D)
CdaWidget(CameraControlWidget2D)
CdaWidget(ClockWidget2D)
CdaWidget(hmibase::widget::color::ColorSwitchWidget2D)
CdaWidget(hmibase::widget::DelegateWidget2D)
CdaWidget(TextBaseLineOffsetWidget2D)
CdaWidget(TextColorWidget2D)
CdaWidget(GridAutoArrangeWidget2D)
CdaWidget(hmibase::widget::gesture::GestureWidget2D)
CdaWidget(hmibase::widget::gizmo::GizmoWidget2D)
CdaWidget(ImageSwitchWidget2D)
CdaWidget(ImageEffectWidget2D)
CdaWidget(ColorEffectWidget2D)
CdaWidget(hmibase::widget::combobox::ComboBoxWidget2D)
CdaWidget(EffectControlWidget2D)
CdaWidget(SolidColorEffectWidget2D)
CdaWidget(MarkerWidget2D)
CdaWidget(MultiSliderWidget2D)
CdaWidget(NodeControlWidget2D)
CdaWidget(hmibase::widget::pageedit::PageEditWidget2D)
CdaWidget(ProgressBarWidget2D)
CdaWidget(PanelSlideWidget2D)
CdaWidget(ScopeWidget2D)
CdaWidget(SliderWidget2D)
CdaWidget(AngularSliderWidget2D)
CdaWidget(SpellerWidget2D)
CdaWidget(SurfaceInputRegionWidget2D)
CdaWidget(EditFieldWidget2D)
CdaWidget(LabelWidget2D)
CdaWidget(TextWidget2D)
CdaWidget(TextWidget2DV2)
CdaWidget(TextExtensionWidget2D)
CdaWidget(TextAreaWidget2D)
CdaWidget(hmibase::widget::text::TextHighlightWidget2D)
CdaWidget(ScrollableTextWidget2D)
CdaWidget(TimerWidget2D)
CdaWidget(hmibase::widget::mesh::MeshWidget2D)
CdaWidget(DirectTextureProvider2D)
CdaWidget(DirectTextureConsumer2D)
CdaWidget(MeterWidget2D)
CdaWidget(OPSWidget2D)
CdaWidget(TwoDimensionSliderWidget2D)
CdaWidget(TextWaitAnimationWidget2D)
CdaWidget(MarginWidget2D)
CdaWidget(ColorBarWidget2D)
CdaWidget(OffscreenTouchProxyWidget2D)
CdaWidget(ViewSwitchWidget2D)
#ifdef VARIANT_S_FTR_ENABLE_RICH_TEXT_WIDGET
CdaWidget(hmibase::widget::richtext::RichTextHighlightWidget2D)
CdaWidget(hmibase::widget::richtext::RichTextMarqueeWidget2D)
CdaWidget(hmibase::widget::richtext::RichTextWidget2D)
CdaWidget(hmibase::widget::richtext::ScrollableRichTextWidget2D)
#endif
#if defined SESA_ARABIC_LAYOUT_FIX
CdaWidget(Candera::ArabicLayouterPatchWidget)
#endif
CdaWidgetsEnd()
CdaWidgetSetPartDefinitionEnd(WidgetSet2DStandard)

WidgetSetAutoRegisterSelf(WidgetSet2DStandard)

void OnParentViewLoad(bool load, Courier::View* view)
{
   if (load)
   {
      if ((0 != view) && (0 != view->ToViewScene2D()))
      {
         Courier::ViewScene::FrameworkWidgetPtrVector& widgetVec = view->ToViewScene2D()->GetFrameworkWidgetPtrVector();
         Courier::ViewScene::FrameworkWidgetPtrVector listVec;
         Courier::ViewScene::FrameworkWidgetPtrVector scrollbarVec;
         Courier::ViewScene::FrameworkWidgetPtrVector otherWidgetsVec;

         for (size_t i = 0; i < widgetVec.Size(); ++i)
         {
            if (widgetVec[i] != 0)
            {
               Candera::WidgetBase* widget = static_cast<Candera::WidgetBase*>(widgetVec[i]);
               if (0 != widget)
               {
                  if (widget->IsTypeOf(ListWidget2D::GetTypeId()))
                  {
                     listVec.Add(widget);
                  }
                  else if (widget->IsTypeOf(ScrollBarWidget2D::GetTypeId()))
                  {
                     scrollbarVec.Add(widget);
                  }
                  else
                  {
                     otherWidgetsVec.Add(widget);
                  }
               }
            }
         }

         if ((listVec.Size() > 0) || (scrollbarVec.Size() > 0))
         {
            widgetVec.Clear();
            for (size_t i = 0; i < listVec.Size(); ++i)
            {
               widgetVec.Add(listVec[i]);
            }
            for (size_t i = 0; i < scrollbarVec.Size(); ++i)
            {
               widgetVec.Add(scrollbarVec[i]);
            }
            for (size_t i = 0; i < otherWidgetsVec.Size(); ++i)
            {
               widgetVec.Add(otherWidgetsVec[i]);
            }
         }
      }
   }
}


static bool initWidgetLibrary()
{
#if defined SESA_ARABIC_LAYOUT_FIX
#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 3)))
   Candera::Layouter::SetAutomaticDirectionBehavior(LayoutAlignment::LayoutDirection::CultureDirection);
#else
   Candera::Layouter::SetAutomaticDirectionBehavior(Candera::CultureDirection);
#endif
#endif

   AppViewHandler::getInstance().registerMessageHandler(DragDrop::DDManager::getInstance());
   DragDrop::DDManager::getInstance().setViewHandler(&AppViewHandler::getInstance());

   AppViewHandler::getInstance().registerMessageHandler(hmibase::widget::AppListDataProviderCache::getInstance());

   ::hmibase::view::ViewControllerBase::SetOnParentViewLoadHook(OnParentViewLoad);

   hmibase::widget::util::WindowInputEventHook::GetInstance().Initialize();

   hmibase::trace::TraceQueryHelper::GetInstance().SetHook(&(hmibase::widget::trace::TraceQueryHelper::GetInstance()));

   //don't set the blur view scene factory as default yet
   //hmibase::view::ViewFactory::SetCreateDefaultViewSceneFunc(hmibase::widget::blur::BlurViewSceneFactory::CreateBlurViewScene);
   return true;
}


static bool s_forceInitAutomaticDirectionBehavior = initWidgetLibrary();
