/* ***************************************************************************************
* FILE:          WidgetSet2DStandard.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WidgetSet2DStandard is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
//lint -emacro({665}, _CdaStaticAggregation)
//lint -emacro({446}, _CdaStaticAggregation)
#include "widget2D_std_if.h"
#include "Widgets/WidgetSetCore.h"

#include "Widgets/2D/List/ListWidget2D.h"
#include "Widgets/2D/List/CoverflowListWidget2D.h"
#include "Widgets/2D/ScrollBar/ScrollBarWidget2D.h"
#include "Widgets/2D/ScrollBarButton/ScrollBarButtonWidget2D.h"
#include "Widgets/2D/Toggle/ToggleWidget2D.h"
#include "Widgets/2D/Switch/SwitchWidget2D.h"
#include "Widgets/2D/OverlayLayouter/OverlayLayouterWidget2D.h"
#include "Widgets/2D/BaseLineLayouter/BaseLineLayouterWidget2D.h"
#include "Widgets/2D/DockSide/DockSideWidget2D.h"
#include "Widgets/2D/Collapse/CollapseWidget2D.h"
#include "Widgets/2D/Size/SizeWidget2D.h"
#include "Widgets/2D/CanvasLayouter/CanvasLayouterWidget2D.h"
#include "Widgets/2D/DropDownList/DropDownListWidget2D.h"
#include "Widgets/2D/TempWidgets2D.h"
#include "Widgets/2D/ListItemAnimationMarker/ListItemAnimationMarkerWidget2D.h"
#include "Widgets/2D/ListOverscroll/ListOverscrollWidget2D.h"

CdaWidgetSetPartDefinitionBegin(WidgetSet2DList)
CdaDescription("HMI-Base Widget Set List Widget")
CdaVersion(HMI_BASE_WIDGET_VERION)
CdaWidgets()
CdaWidget(ListWidget2D)                      // replacement for FlexListWidget2D
CdaWidget(ListBindingWidget2D)               // replacement for ControlTemplateWidget2D
CdaWidget(ScrollBarWidget2D)                 // replacement for FlexScrollBar2D
CdaWidget(ScrollBarButtonWidget2D)           // replacement for FlexScrollBarButton2D
CdaWidget(ToggleWidget2D)                    // replacement for FlexToggleWidget2D
CdaWidget(SwitchWidget2D)                    // replacement for FlexSwitchWidget2D
CdaWidget(OverlayLayouterWidget2D)           // replacement for FlexOverlayLayouterWidget2D
CdaWidget(BaseLineLayouterWidget2D)          // replacement for FlexBaseLineLayouterWidget2D
CdaWidget(DockSideWidget2D)                  // replacement for FlexDockSideWidget2D
CdaWidget(CollapseWidget2D)                  // replacement for FlexCollapseWidget2D
CdaWidget(SizeWidget2D)                      // replacement for FlexSizeWidget2D
CdaWidget(CanvasLayouterWidget2D)            // replacement for FlexCanvasLayouterWidget2D
CdaWidget(DropDownListWidget2D)              // replacement for FlexDropdownListWidget2D
CdaWidget(CoverflowListWidget2D)
CdaWidget(ListItemAnimationMarkerWidget2D)
CdaWidget(ListOverscrollWidget2D)
CdaWidgetsEnd()
CdaWidgetSetPartDefinitionEnd(WidgetSet2DList)

WidgetSetAutoRegisterSelf(WidgetSet2DList)
