/* ***************************************************************************************
* FILE:          ViewSwitchWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ViewSwitchWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ViewSwitchWidget2D_H)
#define ViewSwitchWidget2D_H

#include <Widgets/2D/ViewSwitch/generated/ViewSwitchWidget2DBase.h>

class ViewSwitchWidget2D : public ViewSwitchWidget2DBase
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ViewSwitchWidget2D, ViewSwitchWidget2DBase);

      ViewSwitchWidget2D();
      virtual ~ViewSwitchWidget2D();

      //no list support yet
      //virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      virtual void Update();
      virtual void Finalize();

      virtual void OnParentViewRenderingEnabled(bool enable);
      virtual void OnParentViewActivate(bool activate);
      virtual void OnParentViewLoad(bool load);

      void loadView(const Courier::ViewId& viewId, bool load);
      void activateView(const Courier::ViewId& viewId, bool activate);
      void unloadAllViews();

      CdaWidget2DDef(ViewSwitchWidget2D, ViewSwitchWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      virtual void OnChanged(Courier::UInt32 /*propertyId*/);

      Courier::ViewId _selectedViewId;
      FeatStd::UInt32 _selectedViewIndex;
      bool _invalid;
};


#endif
