/* ***************************************************************************************
* FILE:          TwoDimensionSliderWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TwoDimensionSliderWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef TwoDimensionSliderWidget2D_h
#define TwoDimensionSliderWidget2D_h

#include "Widgets/2D/TwoDimensionSlider/generated/TwoDimensionSliderWidget2DBase.h"
#include "Widgets/2D/TwoDimensionSlider/generated/TwoDimensionSliderWidget2DMessages.h"


class TwoDimensionSliderWidget2D : public TwoDimensionSliderWidget2DBase
{
   public:
      TwoDimensionSliderWidget2D();
      virtual ~TwoDimensionSliderWidget2D();

      CGI_WIDGET_RTTI_DECLARATION(TwoDimensionSliderWidget2D, TwoDimensionSliderWidget2DBase);

      virtual void InitWidget();
      virtual void Update();
      virtual bool OnMessage(const Courier::Message& msg);
      virtual void OnParentViewLoad(bool enable);
      virtual void OnChanged(::FeatStd::UInt32 propertyId);

      CdaWidget2DDef(TwoDimensionSliderWidget2D, TwoDimensionSliderWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
   protected:
      bool composerPropVisibleFilterPermittedArea() const;
   private:
      void updateNodes();
      void calcNoOfPixelsPerUnit();
      void checkValueRange();
      void setInternValueFromPixelPos(const FeatStd::Float fPosX, const FeatStd::Float fPosY);
      void postCurrentValue(bool draging);
      bool touchMessage(const Courier::TouchMsg* msg);
      bool moveMessage(const Widgets::TwoDimensionSilder::MoveMsg* msg);

      Candera::Vector2 getPixelPosFromInternValue();
      Candera::Vector2 getWorldPos() const;
      Candera::Rectangle getTouchAreaRect() const;

      Candera::Vector2  _touchStartPosition;
      bool              _moved;
      bool              _invalidateValueIntern;
      bool              _invalidateValueExtern;
      bool              _invalidateAll;
      Candera::Rectangle _area;
      FeatStd::Float    _noOfPixelsPerUnitInHorz;
      FeatStd::Float    _noOfPixelsPerUnitInVertical;
      Candera::Node2D*  _crosshairKnobNode;
      Candera::Node2D*  _crosshairHorNode;
      Candera::Node2D*  _crosshairVerNode;
      FeatStd::Int32    _horInternalValue;
      FeatStd::Int32    _verInternalValue;
};


#endif // TwoDimensionSliderWidget2D_h
