/* ***************************************************************************************
* FILE:          TextHighlightWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TextHighlightWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef hmibase_TextHighlightWidget2D_h_
#define hmibase_TextHighlightWidget2D_h_

#include <Widgets/2D/Text/TextWidgetUtils.h>
#include <Widgets/2D/TextHighlight/generated/TextHighlightWidget2DBase.h>

namespace hmibase {
namespace widget {
namespace text {

class TextHighlightWidget2D : public TextHighlightWidget2DBase
{
   public:

      CGI_WIDGET_RTTI_DECLARATION(TextHighlightWidget2D, TextHighlightWidget2DBase);
      TextHighlightWidget2D();
      virtual ~TextHighlightWidget2D();

      virtual void Update();
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      CdaWidget2DDef(TextHighlightWidget2D, TextHighlightWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      virtual void OnNodeChanged();
      virtual void OnChanged(FeatStd::UInt32 propertyId);

      bool _invalid;

      Candera::RenderNode* _highlightNode;
      typedef std::vector<BaseGlyphData> BaseGlyphDataVector;
      BaseGlyphDataVector _highlightGlyphVectorData;

      TextBrushData::SharedPointer _textBrushData;
      size_t _lastTextBrushDataUpdateCount;
};


}
}


}

#endif //hmibase_TextHighlightWidget2D_h_
