/* ***************************************************************************************
* FILE:          TextBaseLineOffsetWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TextBaseLineOffsetWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef TextBaseLineOffset_WIDGET2D_H
#define TextBaseLineOffset_WIDGET2D_H

#include <bitset>
#include "CanderaPlatform/Device/Common/Effects/TextBrushBlend.h"
#include "Widgets/2D/TextBaseLineOffset/generated/TextBaseLineOffsetWidget2DBase.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"

class TextAreaWidget2D;

/* ***************************************************************************************
* Provides control over a 2D node allowing to change its properties by using data binding sources or to expose them outside composites.
* There is no internal storage in the widget for the property values, they are set/retrieved directly on/from the node.
*************************************************************************************** */
class TextBaseLineOffsetWidget2D : public TextBaseLineOffsetWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(TextBaseLineOffsetWidget2D, TextBaseLineOffsetWidget2DBase);

      TextBaseLineOffsetWidget2D();
      virtual ~TextBaseLineOffsetWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      virtual void Update();
      virtual void OnNodeChanged();
      virtual void OnChanged(FeatStd::UInt32 propertyId);

   private:
      CdaWidget2DDef(TextBaseLineOffsetWidget2D, TextBaseLineOffsetWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

      void UpdateTextBrush();

      Candera::TextBrush* _textBrush;
      TextAreaWidget2D* _textAreaWidget;
      float _cachedTextHeight;
};


#endif
