/* ***************************************************************************************
* FILE:          TextAreaWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TextAreaWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(TextAreaWidget2D_h)
#define TextAreaWidget2D_h

#include "Widgets/2D/TextArea/generated/TextAreaWidget2DBase.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"

class TextAreaWidget2D : public TextAreaWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      // constructor/destructor
      TextAreaWidget2D();
      virtual ~TextAreaWidget2D();

      // overridden from WidgetBase
      virtual void InitWidget();
      virtual void Update();
      virtual void CultureChanged();
      // RTTI
      CGI_WIDGET_RTTI_DECLARATION(TextAreaWidget2D, TextAreaWidget2DBase);

      // overridden from Framework widget
      virtual bool OnMessage(const Courier::Message& msg);
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      FeatStd::Int16 GetEffectiveNumberOfLines() const;
      Candera::Vector2 GetBasePoint() const;

      CdaWidget2DDef(TextAreaWidget2D, TextAreaWidget2DBase)
      CdaProperties()

      CdaBindableProperty(Enabled, bool, IsEnabled, SetEnabled)
      CdaCategory("Mode")
      CdaDescription("Sets of the text to Enabled/Disabled state.")
      CdaBindablePropertyEnd()

      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      // overridden from TextAreaWidget2DBase
      virtual void OnChanged(Candera::UInt32 propertyId);

      // overridden from RichTextWidget
      virtual void vUpdateNode();

      virtual bool bIsReLayoutNeeded();
      virtual bool bIsReRenderNeeded();

      virtual void vLayoutRichText();
      virtual void vRenderRichText();

   private:
      static const Candera::UInt8 c_Max_Text_Params;
      static const Candera::TChar c_Text_Param_Mark;

      FeatStd::String m_oParameterMark;

      bool m_bIsScrollEnabled;
      Candera::Float m_flScrollOffset;
      Candera::UInt32 m_u32ScrollStartTime;

      RichText::ColorChunk* m_pNormalColorChunk1;
      RichText::ColorChunk* m_pNormalColorChunk2;
      RichText::ColorChunk* m_pHighlightColorChunk;

      RichText::TextChunk* m_pTextChunk1;
      RichText::TextChunk* m_pTextChunk2;
      RichText::TextChunk* m_pTextChunk3;

      mutable FeatStd::Int16 m_effectiveNumberOfLines;
      mutable Candera::Rectangle m_layoutingRect;
      Candera::Vector2 m_basePoint;

      //Class member functions
      bool bTruncateText(const FeatStd::String& sSrcString, FeatStd::String& sDestString, Candera::TruncationMode enTruncationMode) const;
      void vCalculateScrollOffset();
      void vFindString(const FeatStd::String& sText, const FeatStd::String& sSubStr, Candera::UInt16& u16StartIndex, Candera::UInt16& u16Count) const;
      void vDoProcessDynamicText(const FeatStd::String& sSrcString, FeatStd::String& sDestString) const;

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(TextAreaWidget2D);
};


#endif // TextAreaWidget2D_h
