/* ***************************************************************************************
* FILE:          TextLayoutingInfoListener.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TextLayoutingInfoListener is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef _HMIBASE_TEXT_LAYOUTING_INFO_LISTENER_H_
#define _HMIBASE_TEXT_LAYOUTING_INFO_LISTENER_H_
#include <vector>
#include <Candera/TextEngine/Types.h>

namespace hmibase {
namespace widget {
namespace text {

class TextLayoutingInformation;

class TextLayoutingInfoListener
{
   public:
      virtual void OnLayoutingInfoChanged(TextLayoutingInformation& data) = 0;
};


class TextLayoutingInformation
{
   public:
      TextLayoutingInformation() : m_charCountEachLine(), m_rectTopEachLine() {}
      ~TextLayoutingInformation() {}

      std::vector<Candera::UInt32>& GetCharCountEachLine()
      {
         return m_charCountEachLine;
      }
      void SetCharCountEachLine(std::vector<Candera::UInt32>& data)
      {
         m_charCountEachLine.clear();
         m_charCountEachLine = data;
      }

      std::vector<Candera::Int32>& GetRectTopEachLine()
      {
         return m_rectTopEachLine;
      }
      void SetRectTopEachLine(std::vector<Candera::Int32>& data)
      {
         m_rectTopEachLine.clear();
         m_rectTopEachLine = data;
      }

   private:
      std::vector<Candera::UInt32> m_charCountEachLine;
      std::vector<Candera::Int32> m_rectTopEachLine;
};


} // namespace
} // namespace
} // namespace

#endif //_HMIBASE_TEXT_LAYOUTING_INFO_LISTENER_H_
