/* ***************************************************************************************
* FILE:          TempWidgets2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TempWidgets2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef _WIDGETS_2D_H
#define _WIDGETS_2D_H

#include "Widgets/2D/Toggle/ToggleWidget2D.h"
#include "Widgets/2D/Switch/SwitchWidget2D.h"
#include "Widgets/2D/OverlayLayouter/OverlayLayouterWidget2D.h"
#include "Widgets/2D/BaseLineLayouter/BaseLineLayouterWidget2D.h"
#include "Widgets/2D/DockSide/DockSideWidget2D.h"
#include "Widgets/2D/Size/SizeWidget2D.h"
#include "Widgets/2D/Collapse/CollapseWidget2D.h"
#include "Widgets/2D/CanvasLayouter/CanvasLayouterWidget2D.h"
#include "Widgets/2D/ScrollBar/ScrollBarWidget2D.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateWidget2D.h"
#include "Widgets/2D/List/ListWidget2D.h"
#include "Widgets/2D/DropDownList/DropDownListWidget2D.h"
#include "Widgets/2D/ScrollBarButton/ScrollBarButtonWidget2D.h"


class FlexToggleWidget2D : public ToggleWidget2D
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(FlexToggleWidget2D, ToggleWidget2D);

      CdaWidget2DDef(FlexToggleWidget2D, ToggleWidget2D)

      CdaDescription("DEPRECATED! Don't use this widget! Use ToggleWidget2D instead.")
      CdaReadableName("FlexToggleWidget2D")
      CdaCategory("Deprecated")

      CdaProperties()
      CdaPropertiesEnd()

      CdaWidgetDefEnd()
};


class FlexSwitchWidget2D : public SwitchWidget2D
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(FlexSwitchWidget2D, SwitchWidget2D);

      CdaWidget2DDef(FlexSwitchWidget2D, SwitchWidget2D)

      CdaDescription("DEPRECATED! Don't use this widget! Use SwitchWidget2D instead.")
      CdaReadableName("FlexSwitchWidget2D")
      CdaCategory("Deprecated")

      CdaProperties()
      CdaPropertiesEnd()

      CdaWidgetDefEnd()
};


class FlexOverlayLayouterWidget2D : public OverlayLayouterWidget2D
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(FlexOverlayLayouterWidget2D, OverlayLayouterWidget2D);

      CdaWidget2DDef(FlexOverlayLayouterWidget2D, OverlayLayouterWidget2D)

      CdaDescription("DEPRECATED! Don't use this widget! Use OverlayLayouterWidget2D instead.")
      CdaReadableName("FlexOverlayLayouterWidget2D")
      CdaCategory("Deprecated")

      CdaProperties()
      CdaPropertiesEnd()

      CdaWidgetDefEnd()
};


class FlexBaseLineLayouterWidget2D : public BaseLineLayouterWidget2D
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(FlexBaseLineLayouterWidget2D, BaseLineLayouterWidget2D);

      CdaWidget2DDef(FlexBaseLineLayouterWidget2D, BaseLineLayouterWidget2D)

      CdaDescription("DEPRECATED! Don't use this widget! Use BaseLineLayouterWidget2D instead.")
      CdaReadableName("FlexBaseLineLayouterWidget2D")
      CdaCategory("Deprecated")

      CdaProperties()
      CdaPropertiesEnd()

      CdaWidgetDefEnd()
};


class FlexDockSideWidget2D : public DockSideWidget2D
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(FlexDockSideWidget2D, DockSideWidget2D);

      CdaWidget2DDef(FlexDockSideWidget2D, DockSideWidget2D)

      CdaDescription("DEPRECATED! Don't use this widget!")
      CdaReadableName("FlexDockSideWidget2D")
      CdaCategory("Deprecated")

      CdaProperties()
      CdaPropertiesEnd()

      CdaWidgetDefEnd()
};


class FlexSizeWidget2D : public SizeWidget2D
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(FlexSizeWidget2D, SizeWidget2D);

      CdaWidget2DDef(FlexSizeWidget2D, SizeWidget2D)

      CdaDescription("DEPRECATED! Don't use this widget! Use SizeWidget2D instead.")
      CdaReadableName("FlexSizeWidget2D")
      CdaCategory("Deprecated")

      CdaProperties()
      CdaPropertiesEnd()

      CdaWidgetDefEnd()
};


class FlexCollapseWidget2D : public CollapseWidget2D
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(FlexCollapseWidget2D, CollapseWidget2D);

      CdaWidget2DDef(FlexCollapseWidget2D, CollapseWidget2D)

      CdaDescription("DEPRECATED! Don't use this widget! Instead set the Collapsible property of the node and hide it using the Visible property of any widget attached to it.")
      CdaReadableName("FlexCollapseWidget2D")
      CdaCategory("Deprecated")

      CdaProperties()
      CdaPropertiesEnd()

      CdaWidgetDefEnd()
};


class FlexCanvasLayouterWidget2D : public CanvasLayouterWidget2D
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(FlexCanvasLayouterWidget2D, CanvasLayouterWidget2D);

      CdaWidget2DDef(FlexCanvasLayouterWidget2D, CanvasLayouterWidget2D)

      CdaDescription("DEPRECATED! Don't use this widget! Use an overlay layouter instead.")
      CdaReadableName("FlexCanvasLayouterWidget2D")
      CdaCategory("Deprecated")

      CdaProperties()
      CdaPropertiesEnd()

      CdaWidgetDefEnd()
};


class FlexScrollBar2D : public ScrollBarWidget2D
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(FlexScrollBar2D, ScrollBarWidget2D);

      CdaWidget2DDef(FlexScrollBar2D, ScrollBarWidget2D)

      CdaDescription("DEPRECATED! Don't use this widget! Use ScrollBarWidget2D instead.")
      CdaReadableName("FlexScrollBar2D")
      CdaCategory("Deprecated")

      CdaProperties()
      CdaPropertiesEnd()

      CdaWidgetDefEnd()
};


class FlexScrollBarButton2D : public ScrollBarButtonWidget2D
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(FlexScrollBarButton2D, ScrollBarButtonWidget2D);

      CdaWidget2DDef(FlexScrollBarButton2D, ScrollBarButtonWidget2D)

      CdaDescription("DEPRECATED! Don't use this widget! Use ScrollBarButtonWidget2D instead.")
      CdaReadableName("FlexScrollBarButton2D")
      CdaCategory("Deprecated")

      CdaProperties()
      CdaPropertiesEnd()

      CdaWidgetDefEnd()
};


class ListBindingWidget2D : public ControlTemplateWidget2D
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ListBindingWidget2D, ControlTemplateWidget2D);

      CdaWidget2DDef(ListBindingWidget2D, ControlTemplateWidget2D)

      CdaDescription("Implements the list binding. See the list widget documentation.")
      CdaReadableName("ListBindingWidget2D")
      CdaCategory("List")

      CdaProperties()
      CdaPropertiesEnd()

      CdaWidgetDefEnd()
};


class FlexListWidget2D : public ListWidget2D
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(FlexListWidget2D, ListWidget2D);

      CdaWidget2DDef(FlexListWidget2D, ListWidget2D)

      CdaDescription("DEPRECATED! Don't use this widget! Use ListWidget2D instead.")
      CdaReadableName("FlexListWidget2D")
      CdaCategory("Deprecated")

      CdaProperties()
      CdaPropertiesEnd()

      CdaWidgetDefEnd()
};


class FlexDropdownListWidget2D : public DropDownListWidget2D
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(FlexDropdownListWidget2D, DropDownListWidget2D);

      CdaWidget2DDef(FlexDropdownListWidget2D, DropDownListWidget2D)

      CdaDescription("DEPRECATED! Don't use this widget! Use DropDownListWidget2D instead.")
      CdaReadableName("FlexDropdownListWidget2D")
      CdaCategory("Deprecated")

      CdaProperties()
      CdaPropertiesEnd()

      CdaWidgetDefEnd()
};


#endif // _WIDGETS_2D_H
