/* ***************************************************************************************
* FILE:          SwitchWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SwitchWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "SwitchWidget2D.h"
#include <Widgets/2D/ControlTemplate/ControlTemplateBinding.h>


#include <Trace/ToString.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_SWITCH
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/SwitchWidget2D.cpp.trc.h"
#endif


CGI_WIDGET_RTTI_DEFINITION(SwitchWidget2D);


SwitchWidget2D::SwitchWidget2D()
{
}


SwitchWidget2D::~SwitchWidget2D()
{
}


bool SwitchWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const SwitchWidget2D* original = CLONEABLE_WIDGET_CAST<const SwitchWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      SetBitmaskEnabled(original->GetBitmaskEnabled());

      if (ControlTemplateBinding::IsSelectedBindable(*this))
      {
         Candera::Int32 value = ControlTemplateBinding::GetSelectedValue(*this);
         SetIndex(Candera::UInt32(value));
      }
      else
      {
         SetIndex(original->GetIndex());
      }

      cloned = true;
   }
   return cloned;
}


void SwitchWidget2D::Update()
{
   if (GetNode() != NULL)
   {
      ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "Update index=%u bitmaskEnabled=%u %s",
                          GetIndex(), GetBitmaskEnabled(), HMIBASE_TO_STRING_VW(this)));

      Candera::Node2D* current = GetNode()->GetFirstChild();
      Candera::UInt32 currentIndex = 0;
      bool invalidate = false;
      bool invalidateLayout = false;
      while (current != NULL)
      {
         bool visible = GetBitmaskEnabled() ? ((GetIndex() & (1u << currentIndex)) != 0) : (GetIndex() == currentIndex);
         if (visible != current->IsRenderingEnabled())
         {
            invalidate = true;

            // if the visibility of a collapsible node is changed then we invalidate the layout
            invalidateLayout = invalidateLayout || Candera::Layouter::IsCollapsible(*current);

            current->SetRenderingEnabled(visible);
         }
         current = current->GetNextSibling();
         ++currentIndex;
      }
      if (invalidate)
      {
         Invalidate();
      }
      if (invalidateLayout)
      {
         Candera::Layouter::InvalidateLayout(GetNode());
      }
   }
}


void SwitchWidget2D::OnChanged(Courier::UInt32 propertyId)
{
   Base::OnChanged(propertyId);
}


void SwitchWidget2D::OnNodeChanged()
{
   triggerUpdate();
}
