/* ***************************************************************************************
* FILE:          SpellerWidget2D_Constants.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SpellerWidget2D_Constants is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef HTC_SPELLERWIDGET_2D_CONSTANTS_H
#define HTC_SPELLERWIDGET_2D_CONSTANTS_H

//Header files

//SpellerMode Enumeration Declaration

#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(enSpellerMode) \
        ENUM_DATA_TYPE_ITEM_VALUE(FreeMode, 0) \
        ENUM_DATA_TYPE_ITEM_VALUE(MatchMode, 1) \
    ENUM_DATA_TYPE_END(enSpellerMode)
#include <Candera/System/MetaInfo/EnumDataType.h>

//SpellerType Enumeration Declaration
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(enSpellerType) \
        ENUM_DATA_TYPE_ITEM_VALUE(Default, 0) \
        ENUM_DATA_TYPE_ITEM_VALUE(Pin, 1) \
        ENUM_DATA_TYPE_ITEM_VALUE(Phone, 2) \
        ENUM_DATA_TYPE_ITEM_VALUE(HouseNo, 3) \
        ENUM_DATA_TYPE_ITEM_VALUE(BTPassKey, 4) \
        ENUM_DATA_TYPE_ITEM_VALUE(Others, 5) \
        ENUM_DATA_TYPE_ITEM_VALUE(CustomSequence, 6) \
    ENUM_DATA_TYPE_END(enSpellerType)
#include <Candera/System/MetaInfo/EnumDataType.h>

//Speller active KeypadFormat Enumeration Declaration
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(enKeypadFormat) \
        ENUM_DATA_TYPE_ITEM_VALUE(Basic_QWERTY, 1) \
        ENUM_DATA_TYPE_ITEM_VALUE(Basic_ABC, 2) \
        ENUM_DATA_TYPE_ITEM_VALUE(Basic_qwerty, 3) \
        ENUM_DATA_TYPE_ITEM_VALUE(Basic_abc, 4) \
        ENUM_DATA_TYPE_ITEM_VALUE(Numeric, 5) \
        ENUM_DATA_TYPE_ITEM_VALUE(Special, 6) \
    ENUM_DATA_TYPE_END(enKeypadFormat)
#include <Candera/System/MetaInfo/EnumDataType.h>


//SubSpeller Enumeration Declaration
/*
Every SPELLERBUTTONTYPE_Char may either either have sub-speller character(s) or may not.
If it has sub-speller character(s), then the following possibilities would exist
*/
enum enSubSplr
{
   SUBSPLR_NoSubSplr = 0,                          //sub-speller not valid for this character, a default value
   SUBSPLR_BothCharEnabled,                        //show the sub-speller symbol
   SUBSPLR_OnlyMainCharEnabled,                    //do not show the sub-speller symbol (valid only for match mode)
   SUBSPLR_OnlySubSplrCharEnabled_ButOnlyOne,      //do not show the sub-speller symbol (valid only for match mode)
   SUBSPLR_OnlySubSplrCharEnabled_ButMoreThanOne,  //show the sub-speller symbol (valid only for match mode)
   SUBSPLR_BothCharDisabled                        //do not show the sub-speller symbol (valid only for match mode)
};


//Macros
#define MAX_BUTTONS_PER_LAYOUT      ((Candera::UInt8) 100)                  //Maximum buttons in a layout that Speller supports
#define MAX_CHAR_BYTES              ((Candera::UInt8) 4)                    //Value is 4 since the max size of a character can be 4 bytes
#define WIDGET_NAME_ARRAY_SIZE      ((Candera::UInt8) 100)                  //This includes the composite name combined with '/' & button node name
#define CONCATENATED_STRING_SIZE    ((Candera::UInt8) 50)                   //This is the maximum size that sequence string should have
#define SEQ_DEFAULT                 ((const Candera::TChar*) "default")     //Speller type 'default'
#define SEQ_PIN                     ((const Candera::TChar*) "pin")         //Speller type 'pin'
#define SEQ_PHONE                   ((const Candera::TChar*) "phone")       //Speller type 'phone'
#define SEQ_HOUSENO                 ((const Candera::TChar*) "HouseNo")     //Speller type 'HouseNo'
#define SEQ_BTPASSKEY               ((const Candera::TChar*) "BTPassKey")   //Speller type 'BTPassKey'
#define TEXT_MATCHMODE              ((const Candera::TChar*) "match")       //Speller mode 'match'
#define TEXT_FREEMODE               ((const Candera::TChar*) "freetext")    //Speller mode 'freetext'
#define SPACE_CHAR                  ((const Candera::TChar*) " ")           //Space character used by Speller

//TODO("Rigt now scene path is hardcoded, but this will later be taken as part of speller xml itself")
#define SCENE_PATH                  ((const Candera::TChar*) "TestApp#Module1#")  //Path where all speller scenes exist in Scene composer


#endif //HTC_SPELLERWIDGET_2D_CONSTANTS_H
