/* ***************************************************************************************
* FILE:          SpellerConfig.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SpellerConfig is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*************************************************************************************** */
#ifndef _SpellerConfig_H
#define _SpellerConfig_H

#ifdef SPELLERWIDGETCONFIG_EXPORTS
#define SPELLERWIDGETCONFIG_API __declspec(dllexport)
#else
#ifdef WIN32
#define SPELLERWIDGETCONFIG_API __declspec(dllimport)
#else
#define SPELLERWIDGETCONFIG_API
#endif
#endif

/**
*  Class that stores the speller layouts and layout sequences.
*  The data is generated in the file GUI_GenSpeller.h.
*/

typedef char utf8_t;

enum enSplrBtnType
{
   SPLRBTNTYPE_Character = 0,
   SPLRBTNTYPE_Character_Empty,
   SPLRBTNTYPE_Character_Fill,
   SPLRBTNTYPE_Character_Separator,
   SPLRBTNTYPE_Control_Ok,
   SPLRBTNTYPE_Control_Space,
   SPLRBTNTYPE_Control_ToggleWithinLayoutType,
   SPLRBTNTYPE_Control_ToggleLayoutType,
   SPLRBTNTYPE_Control_ToggleCharCase,
   SPLRBTNTYPE_Control_Shift_1,
   SPLRBTNTYPE_Control_Shift_2,
   SPLRBTNTYPE_Control_Shift_3,
   SPLRBTNTYPE_Control_Shift_4,
   SPLRBTNTYPE_Control_Shift_5,
   SPLRBTNTYPE_Control_DeleteAll,
   SPLRBTNTYPE_Control_Invisible,
   SPLRBTNTYPE_Control_Delete,
   SPLRBTNTYPE_Control_CursorRight_Shift,
   SPLRBTNTYPE_Control_CursorLeft_Shift,
   SPLRBTNTYPE_Control_CustomButton_1,
   SPLRBTNTYPE_Control_CustomButton_2,
   SPLRBTNTYPE_Control_CustomButton_3,
   SPLRBTNTYPE_Control_CustomButton_4,
   SPLRBTNTYPE_Control_CustomButton_5
};


class ISpellerConfig
{
   public:
      virtual ~ISpellerConfig() {};
      virtual uint32_t getSequenceIndex(const utf8_t* pcSequenceName) const = 0;
      virtual uint32_t getCtrlCharAttachedLayout(uint32_t nSequenceIndex, uint32_t nLayoutIndex, uint32_t nCtrlChar) const = 0;
      virtual uint32_t getLayoutIndexOfFormat(uint32_t nSequenceIndex, uint32_t nFormat) const = 0;
      virtual const utf8_t* getLayout(uint32_t nSequenceIndex, uint32_t nLayout) const = 0;
      virtual const utf8_t* getLanguage(uint32_t u32code) const = 0;
      virtual const utf8_t* getDefaultLanguage() const = 0;
      virtual const utf8_t* getCountry(uint32_t u32code) const = 0;
      virtual const utf8_t* getDefaultCountry() const = 0;
      virtual const utf8_t* getSplrSeqLayoutType(uint32_t nSequenceIndex, uint32_t nLayoutIndex) const = 0;
      virtual const utf8_t* getSubSplrSeqLayoutType(uint32_t u32SubSplrSeqIndex, const utf8_t* pcMainChar) const = 0;
      virtual const utf8_t* getSubSplrCharacters(uint32_t u32SubSplrSeqIndex, const utf8_t* pcMainChar) const = 0;
      virtual const utf8_t* getSplrLayoutType(unsigned char nIndex) const = 0;
      virtual uint32_t getSubSplrSeqIndex(const utf8_t* pcSubSplrSeqName) const = 0;
      virtual uint32_t getSeperatorCharacter() const = 0;
      virtual uint32_t getSubSplrCharacter() const = 0;
      virtual uint32_t getNumberOfLayoutTypes() const = 0;
      virtual uint32_t getLayoutIndex(uint32_t nSequenceIndex, uint32_t nLayout) const = 0;
      virtual uint32_t getButtonTypeCtrlChar(enSplrBtnType enType) const = 0;
      virtual enSplrBtnType getButtonBasedOnXmlInfo(uint32_t u32Ucs4Val) const = 0;
      virtual uint32_t getMatchingLayout(uint32_t nSequenceIndex, uint32_t nActiveLayout, const utf8_t* pcValidCharacterSet) const = 0;
};


extern "C" SPELLERWIDGETCONFIG_API ISpellerConfig* CreateSpellerConfigInstance(void);
typedef ISpellerConfig* (*pfktCreateSpellerConfigInstance)(void);

#endif // #ifndef _SpellerConfig_H
