/* ***************************************************************************************
* FILE:          SpellerButtonController2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SpellerButtonController2D.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(SpellerButtonController2D_h)
#define SpellerButtonController2D_h


#include <AppUtils/ObjectGuard.h>
#include <Widgets/2D/Button/ButtonBubbleController2D.h>


class ButtonWidget2D;
class SpellerWidget2D;


/*****************************************************************************/
/** Attach this controller to buttons in speller layout scenes in order to display a bubble on press or to be able to select sub speller character without releasing the finger.
*/
class SpellerButtonController2D : public ButtonBubbleController2D
{
      FEATSTD_TYPEDEF_BASE(ButtonBubbleController2D);

   public:
      CANDERA_RTTI_DECLARATION(SpellerButtonController2D);

      SpellerButtonController2D(hmibase::widget::adorner::AdornerManager& bubbleAdornerManager, const hmibase::widget::adorner::AdornerMarkerFilter& bubbleAdornerMarkerFilter);
      virtual ~SpellerButtonController2D();

      //overrides from WidgetController
      virtual bool OnMessage(DelegateWidget& widget, const Courier::Message& msg);

      //overrides from ButtonController2D
      virtual bool onReaction(ButtonWidget2D& button, enReaction reaction);
      virtual bool OnTapGesture(DelegateWidget& widget, const hmibase::input::gesture::GestureEvent& gestureData);

      /* Callback for sub speller open and close */
      virtual bool OnSubSpellerStatusUpdMessage(DelegateWidget& widget, const SubSpellerStatusUpdMsg& msg);
      virtual bool OnActivationResMessage(DelegateWidget& widget, const Courier::ActivationResMsg& msg);

      /* Updates sub speller buttons on touch move or when the subspeller is opened */
      virtual void UpdateSubSpellerButtons(DelegateWidget& widget, const Candera::Vector2& touchCoordinate);

      /* Finds the buttons in the opened sub speller */
      virtual bool FindSubSpellerButtons(DelegateWidget& widget, std::vector<ButtonWidget2D*>& buttons);

      virtual ButtonWidget2D* FindClosestSubSpellerButton(DelegateWidget& widget, std::vector<ButtonWidget2D*>& buttons, const Candera::Vector2& touchCoordinates);

      /* Verifies if a sub speller button is valid (enabled, etc) */
      virtual bool IsSubSpellerButtonValid(ButtonWidget2D& button);

      /* Sets a sub speller button as selected or unselected (uses Active button flag) */
      virtual void SetSubSpellerButtonSelected(ButtonWidget2D& button, bool selected);

   protected:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(SpellerButtonController2D);

      Candera::Vector2 _touchCoordinates;
      std::string _subSpellerViewName;

      typedef hmibase::util::ObjectAccessor<ButtonWidget2D> ButtonWidgetAccessor;
      ButtonWidgetAccessor _selectedSubSpellerButton;
};


#endif
