/* ***************************************************************************************
* FILE:          SolidColorEffectWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SolidColorEffectWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef SolidColorEffect_WIDGET2D_H
#define SolidColorEffect_WIDGET2D_H

#include "Widgets/2D/SolidColorEffect/generated/SolidColorEffectWidget2DBase.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"

class Effect2D;

class SolidColorEffectWidget2D : public SolidColorEffectWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(SolidColorEffectWidget2D, SolidColorEffectWidget2DBase);

      SolidColorEffectWidget2D();
      virtual ~SolidColorEffectWidget2D();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

   private:
      virtual void Update();
      virtual void OnNodeChanged()
      {
         _invalid = true;
      }
      virtual void OnChanged(::Candera::UInt32 propertyId);

      bool _invalid;

      CdaWidget2DDef(SolidColorEffectWidget2D, SolidColorEffectWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


#endif
