/* ***************************************************************************************
* FILE:          SolidColorEffectWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SolidColorEffectWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "CanderaPlatform/Device/Common/Effects/SolidColorBrushBlend.h"
#include "SolidColorEffectWidget2D.h"


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_IMAGE
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/SolidColorEffectWidget2D.cpp.trc.h"
#endif


CGI_WIDGET_RTTI_DEFINITION(SolidColorEffectWidget2D);


SolidColorEffectWidget2D::SolidColorEffectWidget2D(): Base(),
   _invalid(true)
{
}


SolidColorEffectWidget2D::~SolidColorEffectWidget2D()
{
}


void SolidColorEffectWidget2D::OnChanged(::Candera::UInt32 propertyId)
{
   Base::OnChanged(propertyId);

   if ((propertyId == FillColorPropertyId) || (propertyId == SizePropertyId))
   {
      _invalid = true;
   }
}


bool SolidColorEffectWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const SolidColorEffectWidget2D* original = CLONEABLE_WIDGET_CAST<const SolidColorEffectWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      SetSize(original->GetSize());
      SetFillColor(original->GetFillColor());

      cloned = true;
   }
   return cloned;
}


void SolidColorEffectWidget2D::Update()
{
   if (_invalid && (GetNode() != NULL))
   {
      Candera::RenderNode* renderNode = Candera::Dynamic_Cast<Candera::RenderNode*>(GetNode());
      if ((renderNode != NULL) && (renderNode->GetEffect(0) != NULL))
      {
         Candera::SolidColorBrush* solidColorBrush = Candera::Dynamic_Cast<Candera::SolidColorBrush*>(renderNode->GetEffect(0)->GetBrushEffect2D());
         if (solidColorBrush != NULL)
         {
            solidColorBrush->Unload();
            Candera::Vector2 size = GetSize();
            if ((size.GetX() >= 0.0f) && (size.GetY() >= 0.0f))
            {
               solidColorBrush->Size().Set(size);
            }
            solidColorBrush->Color().Set(GetFillColor());
            solidColorBrush->Upload();
         }
      }
      Invalidate();

      _invalid = false;
   }
}
