/* ***************************************************************************************
* FILE:          AngularSliderWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AngularSliderWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(AngularSliderWidget2D_H)
#define AngularSliderWidget2D_H

#include "Widgets/2D/AngularSlider/generated/AngularSliderWidget2DBase.h"
#include <Widgets/2D/Touchable2D.h>
#include "Widgets/2D/Animation/AnimationHelperInterface.h"

class AngularSliderWidget2D : public AngularSliderWidget2DBase
{
   public:
      AngularSliderWidget2D();
      virtual ~AngularSliderWidget2D();

      CGI_WIDGET_RTTI_DECLARATION(AngularSliderWidget2D, AngularSliderWidget2DBase);

      //required for FlexList cloning
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      // handling user Touch
      virtual bool OnTouch(const Candera::Camera2D& camera2D, const Candera::Vector2& point);
      virtual void Update();
      void OnParentViewActivate(bool enable);
      void stopExistingAnimations();
   protected:
      virtual void OnAnimationTimeDispatcherChanged();
      // Gesture interface
      virtual bool OnTapGesture(const hmibase::input::gesture::GestureEvent& gestureData);
      virtual bool OnDragGesture(const hmibase::input::gesture::GestureEvent& gestureData);

   private:
      bool	_bIsAngularMarkerTouched;
      bool	_bIsAngularBgTouched;
      bool	_bIsTouchOnBgValid;
      bool	_bUpdateValid;
      bool    _bMoveFlag;
      Candera::Float _actualMaxAngle;
      Candera::Float _actualMinAngle;
      Candera::Float _prevAngle;
      Candera::Float _currentIndicatorRotation;
      Candera::Float _previousIndicatorRotation;
      Candera::Float calculateCurrentRotationVal();
      Candera::Float calculateCurrentValueForAngularPosition(Candera::Float x, Candera::Float y);
      bool isInside(Candera::Float circle_x, Candera::Float circle_y, Candera::Float rad, Candera::Float x, Candera::Float y);
      Candera::Float HandleSemiCircle(Candera::Float centreX, Candera::Float centreY, Candera::Float x, Candera::Float y);
      Candera::Float HandleFullCircle(Candera::Float centreX, Candera::Float centreY, Candera::Float x, Candera::Float y);

      Candera::Float HandleSemiCircleHoriRight(Candera::Float centreX, Candera::Float centreY, Candera::Float x, Candera::Float y);
      Candera::Float HandleSemiCircleHoriLeft(Candera::Float centreX, Candera::Float centreY, Candera::Float x, Candera::Float y);
      Candera::Float HandleSemiCircleVerticalTop(Candera::Float centreX, Candera::Float centreY, Candera::Float x, Candera::Float y);
      Candera::Float HandleSemiCircleVerticalBottom(Candera::Float centreX, Candera::Float centreY, Candera::Float x, Candera::Float y);

      Candera::Float ValidateAngle(Candera::Float fRotationAngle);
      Candera::Float checkValueRange(Candera::Float fValue);

      virtual bool initializeEffectiveMovableArea();
      virtual bool bOnTouchMessage(const Courier::Message& msg);
      virtual void updatePosition();
      bool bOnTouchDown(const hmibase::input::gesture::GestureEvent& gestureData, Candera::Float x, Candera::Float y);
      bool bOnTouchMove(Candera::Float x, Candera::Float y);
      bool bOnTouchUp(Candera::Float x, Candera::Float y);

      AnimationHelperInterface* _animationHelperInterface;

      CdaWidget2DDef(AngularSliderWidget2D, AngularSliderWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


#endif
