/* ***************************************************************************************
* FILE:          SizeWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SizeWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "Widgets/2D/Common/NodeHelper.h"

#include "SizeWidget2D.h"

#include <Trace/ToString.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_NODECONTROL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/SizeWidget2D.cpp.trc.h"
#endif

CGI_WIDGET_RTTI_DEFINITION(SizeWidget2D);


SizeWidget2D::SizeWidget2D() : _invalid(true)
{
   SetSize(Candera::Vector2(-1.0F, -1.0F));
}


SizeWidget2D::~SizeWidget2D()
{
}


bool SizeWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const SizeWidget2D* original = CLONEABLE_WIDGET_CAST<const SizeWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      SetNestedLevel(original->GetNestedLevel());
      SetSize(original->GetSize());

      cloned = true;
   }
   return cloned;
}


void SizeWidget2D::Update()
{
   if (_invalid && (0 != GetNode()))
   {
      Candera::Node2D* node = NodeHelper::GetNestedParent(GetNode(), GetNestedLevel());
      if (0 != node)
      {
         ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "Update size=%12s %s",
                             HMIBASE_TO_STRING(GetSize()), HMIBASE_TO_STRING_VW(this)));
         ETG_TRACE_USR4_DCL((APP_TRACECLASS_ID(), "Update node=%s", HMIBASE_TO_STRING_SPN2D(GetNode())));

         Candera::Layouter::SetSize(*node, GetSize());
         Invalidate();
      }
      _invalid = false;
   }
}


void SizeWidget2D::OnChanged(Courier::UInt32 propertyId)
{
   Base::OnChanged(propertyId);

   _invalid = true;
}


void SizeWidget2D::OnNodeChanged()
{
   _invalid = true;
   triggerUpdate();
}
