/* ***************************************************************************************
* FILE:          ScrollBarWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ScrollBarWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ScrollBarWidget2D_H
#define ScrollBarWidget2D_H

#include "Widgets/2D/Common/FlexScrollable.h"
#include "Widgets/2D/ScrollBar/generated/ScrollBarWidget2DBase.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"

class ScrollBarWidget2D : public ScrollBarWidget2DBase, private FlexScrollableListener
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ScrollBarWidget2D, ScrollBarWidget2DBase);

      ScrollBarWidget2D();
      virtual ~ScrollBarWidget2D();

      virtual void OnParentViewLoad(bool activate);
      virtual bool OnTouch(const Candera::Camera2D& camera, const Candera::Vector2& point);
      virtual bool OnMessage(const Courier::Message& msg);

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);
      virtual void Update();

      void RequestNewPosition(ListChangeType listChangeType, Candera::Int32 value);

      CdaWidget2DDef(ScrollBarWidget2D, ScrollBarWidget2DBase)
      CdaProperties() //Start of properties
      CdaPropertiesEnd() // End of properties
      CdaWidgetDefEnd()

   protected:
      virtual void OnChanged(Courier::UInt32 propertyId);

   private:
      typedef void(*CellSizeSetter)(Candera::GridLayouter* grid, Candera::UInt8 column, Candera::Float size);
      typedef Candera::Float(*RelativePositionGetter)(const Courier::TouchMsg* touchMsg, Candera::Float topPercentage, Candera::Float sliderPercentage,
            Candera::Rectangle slideRefScrollBarBoundingRectangle, const Courier::TouchInfo& slideRefTouchInfo);

      struct ModeSpecificParameters
      {
         FEATSTD_LINT_CURRENT_SCOPE(1712, "No default constructor needed.")

         ModeSpecificParameters(CellSizeSetter aCellSizeSetter, RelativePositionGetter aRelativePositionGetter) :
            _cellSizeSetter(aCellSizeSetter),
            _relativePositionGetter(aRelativePositionGetter)
         {
         }

         CellSizeSetter _cellSizeSetter;
         RelativePositionGetter _relativePositionGetter;
      };

      typedef enum
      {
         NormalState,
         StepBackwardState,
         PageBackwardState,
         SlideState,
         PageForwardState,
         StepForwardState
      } ScrollBarState;

      void PositionKnob(Candera::UInt32 maxPosition, const Candera::UInt32 position);

      void UpdateSliderSizePercentage();

      void UpdateVisibility(const bool scrollBarVisible);

      void RefreshScrollable();
      bool IsNodeTouched(const Candera::Node2D* node, const Courier::TouchMsg& touchMsg);

      void UpdateOnRepeatedMsg();
      void UpdateKnob();

      virtual void OnPositionReached() override;
      virtual void OnContentUpdated() override;
      virtual void OnPreOverscroll(FeatStd::Float percent) override;
      virtual void OnPostOverscroll(FeatStd::Float percent) override;

      void UpdateEnabledStatus();
      void UpdateEnabledStatus(Courier::ViewScene2D& viewScene, Candera::Node2D* node, bool enabled);
      void SetLayouterToCommonAncestor();

      bool OnTouchMsg(const Courier::TouchMsg& touchMsg);

      bool ProcessTouchOnSliderNode(const Courier::TouchMsg& touchMsg);
      bool ProcessTouchOnNode(const Courier::TouchMsg& touchMsg, Candera::Node2D* node, ScrollBarState newState, ListChangeType listChangeType, Candera::Int32 value);

      bool OnLockOutMsg(const LockOutMsg* lockOutMsg);
      FeatStd::Float GetOverscrollSizeLimitted() const;

      bool _invalid;
      bool _lastVisible;
      Candera::UInt32 _lastPosition;
      Candera::UInt32 _lastMaxPosition;
      FlexScrollable* _flexScrollable;
      ScrollBarState _state;
      Courier::TouchInfo _slideRefTouchInfo;
      Candera::Rectangle _slideRefScrollBarBoundingRectangle;
      Candera::UInt32 _timeStamp;
      ModeSpecificParameters _modeSpecificParameters;
      Candera::Float _sliderSizePercentage;
      Candera::Float _pageBackwardSizePercentage;
      Candera::Float _pageBackwardSizePercentageOnDown;
      Candera::Node2D* _scrollableNode;
      LockOutType _lockOutType;
      FeatStd::Float _overscrollPercentBefore;
      FeatStd::Float _overscrollPercentAfter;
      bool _overscroll;
};


#endif
