/* ***************************************************************************************
* FILE:          ScopeWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ScopeWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef Scope_WIDGET2D_H
#define Scope_WIDGET2D_H

#include <Widgets/2D/Scope/generated/ScopeWidget2DBase.h>
#include <Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h>

class ScopeWidget2D : public ScopeWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ScopeWidget2D, ScopeWidget2DBase);

      /*****************************************************************************/
      ScopeWidget2D();
      virtual ~ScopeWidget2D();

      /*****************************************************************************/
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      /*****************************************************************************/
      typedef Candera::UInt32 ScopeMaskType;
      ScopeMaskType getScopeMask() const
      {
         return _scopeMask;
      }
      void setScopeMask(ScopeMaskType value);

   private:
      virtual void Update();
      virtual void OnChanged(Candera::UInt32 propertyId);

      /*****************************************************************************/
      bool _invalid;
      ScopeMaskType _scopeMask;

      /*****************************************************************************/
      CdaWidget2DDef(ScopeWidget2D, ScopeWidget2DBase)
      CdaProperties()

      // we define this property here due to a conflict to a method GetScopeMask which exists in Courier base widget class
      CdaBindableProperty(ScopeMask, ScopeMaskType, getScopeMask, setScopeMask)
      CdaDescription("Scope mask to be applied on the associated node and, if configured so, also on descendents.\nUse a calculator to determine the decimal value containing the required scopes. For example, the decimal value 9 enables Scope 1 and Scope 4.")
      CdaCategory("Scope")
      CdaBindablePropertyEnd()

      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


#endif //Scope_WIDGET2D_H
