/* ***************************************************************************************
* FILE:          ScopeWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ScopeWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "ScopeWidget2D.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_NODECONTROL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ScopeWidget2D.cpp.trc.h"
#endif


CGI_WIDGET_RTTI_DEFINITION(ScopeWidget2D);


/*****************************************************************************/
ScopeWidget2D::ScopeWidget2D() : Base(), _invalid(false), _scopeMask(0xFFffFFff)
{
}


/*****************************************************************************/
ScopeWidget2D::~ScopeWidget2D()
{
}


/*****************************************************************************/
void ScopeWidget2D::setScopeMask(ScopeMaskType value)
{
   if (value != _scopeMask)
   {
      _scopeMask = value;
      _invalid = true;
      triggerUpdate();
   }
}


/*****************************************************************************/
void ScopeWidget2D::OnChanged(Candera::UInt32 propertyId)
{
   Base::OnChanged(propertyId);

   switch (propertyId)
   {
      case ApplyOnDescendentsPropertyId:
         _invalid = true;
         break;

      default:
         break;
   }
}


/*****************************************************************************/
bool ScopeWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const ScopeWidget2D* original = CLONEABLE_WIDGET_CAST<const ScopeWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      setScopeMask(original->getScopeMask());
      SetApplyOnDescendents(original->GetApplyOnDescendents());

      cloned = true;
   }
   return cloned;
}


/*****************************************************************************/
void ScopeWidget2D::Update()
{
   if (_invalid && (GetNode() != NULL))
   {
      GetNode()->SetScopeMask(Candera::ScopeMask(getScopeMask()), GetApplyOnDescendents() ? Candera::Node2D::Deep : Candera::Node2D::Flat);
      Invalidate();

      _invalid = false;
   }
}
