/* ***************************************************************************************
* FILE:          RtCaseFolding.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtCaseFolding is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Candera/TextEngine/Types.h>

namespace hmibase {
namespace widget {
namespace richtext {

class CaseFolding
{
   public:
      static Candera::TextRendering::CodePoint ToLower(Candera::TextRendering::CodePoint codePoint);

   private:
      struct Mapping
      {
         Candera::TextRendering::CodePoint upper;
         Candera::TextRendering::CodePoint lower;

         static FeatStd::Int Compare(Candera::TextRendering::CodePoint left, const CaseFolding::Mapping& right);
      };

      static const Mapping mapping[];
};


}
}


}
