/* ***************************************************************************************
* FILE:          RtElementStyleAccessor.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtElementStyleAccessor is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <FeatStd/Base.h>
#include <Candera/System/Container/Map.h>
#include <FeatStd/Util/ConvenienceMacros.h>
#include <Widgets/2D/RichText/StyleProvider/RtElementStyle.h>

namespace hmibase {
namespace widget {
namespace richtext {

class ElementStyleAccessor
{
   public:
      static ElementStyleAccessor& GetInstance();

      ElementStyle::SharedPointer CreateStyle(const FeatStd::Char* name) const;

      bool AddStyle(const ElementStyle::SharedPointer& style);
      ElementStyle::SharedPointer GetStyle(const FeatStd::Char* name);

   protected:

   private:
      typedef Candera::Internal::Map<const FeatStd::Char*, ElementStyle::SharedPointer> StyleList;

      StyleList m_styles;

      FEATSTD_MAKE_CLASS_STATIC(ElementStyleAccessor);
      FEATSTD_MAKE_CLASS_UNCOPYABLE(ElementStyleAccessor);
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
