/* ***************************************************************************************
* FILE:          RichTextHighlightWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RichTextHighlightWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/generated/RichTextHighlightWidget2DBase.h>
#include <Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h>
#include <Widgets/2D/RichText/Engine/RtEngine.h>
#include <FeatStd/Event/EventListener.h>

namespace hmibase {
namespace widget {
namespace richtext {
class RichTextWidget2D;

class RichTextHighlightWidget2D : public RichTextHighlightWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      RichTextHighlightWidget2D();
      virtual ~RichTextHighlightWidget2D();

      virtual void Update() override;
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap) override;

      CGI_WIDGET_RTTI_DECLARATION(RichTextHighlightWidget2D, RichTextHighlightWidget2DBase);

      CdaWidget2DDef(RichTextHighlightWidget2D, RichTextHighlightWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      virtual void OnChanged(::FeatStd::UInt32 propertyId) override;
      virtual void OnNodeChanged() override;

   private:
      bool m_update;
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
