/* ***************************************************************************************
* FILE:          RtRenderBufferCache.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtRenderBufferCache is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <FeatStd/Container/Vector.h>
#include <Widgets/2D/RichText/Renderer/RtRenderBufferCacheItem.h>


namespace hmibase {
namespace widget {
namespace richtext {


class RenderBufferCache
{
   public:
      RenderBufferCache();
      virtual ~RenderBufferCache();

      FeatStd::UInt32 GetCount();
      RenderBufferCacheItem::SharedPointer Get(FeatStd::UInt32 idx);
      bool TestAndGet(FeatStd::UInt32 idx, RenderBufferCacheItem::SharedPointer& itemPtr);
      void Add(const Candera::Bitmap::SharedPointer& renderBufferBitmap);
      void Clear();

      // Determines whether or not the flag was set and sets it in any case.
      bool TestAndSetRenderNodeUpdateRequestPending();
      void ClearRenderNodeUpdateRequestPending();

      bool HasPendingUpload();

   private:
      typedef FeatStd::Internal::Vector<RenderBufferCacheItem::SharedPointer> RenderBufferVector;
      RenderBufferVector m_renderBuffers;
      bool m_nodeUpdateRequestPending;
      FeatStd::Internal::CriticalSection m_cs;
};


} // namespace richtext
} // namespace widget
} // namespace hmibase
