/* ***************************************************************************************
* FILE:          TruncationTextContext.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TruncationTextContext is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Candera/TextEngine/PreprocessingContext.h>
#include <FeatStd/Container/Vector.h>
#include <litehtml/include/litehtml.h>

namespace hmibase {
namespace widget {
namespace richtext {

class TruncationTextContext : public litehtml::el_text::Context, public Candera::TextRendering::PreprocessingContext
{
      typedef Candera::TextRendering::PreprocessingContext Base;

   public:
      typedef litehtml::el_text::Context::SharedPtr SharedPointer;

      class TruncateGlyphData : public Candera::TextRendering::PreprocessingContext::GlyphData
      {
            friend class TruncationTextContext;

         public:
            TruncateGlyphData();

            virtual Candera::TextRendering::FontIdentifier GetFontIdentifier() const override;
            virtual Candera::TextRendering::GlyphIndex GetGlyphIndex() const override;
            virtual Candera::TextRendering::TextPosition GetCharacterPosition() const override;
            virtual Candera::TextRendering::PixelPosition2D GetPosition() const override;

            Candera::TextRendering::PixelSize2D GetAdvance() const;
            Candera::TextRendering::TextRect GetRect() const;
            Candera::TextRendering::GlyphBitmap::Direction GetDirection() const;

            void SetGlyphIndex(Candera::TextRendering::GlyphIndex index) const;

         private:
            Candera::TextRendering::GlyphBitmap::Direction m_direction;
            Candera::TextRendering::FontIdentifier m_fontIdentifier;
            mutable Candera::TextRendering::GlyphIndex m_glyphIndex;
            Candera::TextRendering::TextPosition m_characterPosition;
            Candera::TextRendering::PixelPosition2D m_position;
            Candera::TextRendering::PixelSize2D m_advance;
            Candera::TextRendering::TextRect m_rect;
      };

      typedef FeatStd::Internal::Vector<TruncateGlyphData> DataContainer;
      typedef DataContainer::ConstIterator DataContainerIterator;
      typedef Candera::ForwardIterator<DataContainerIterator> TruncateGlyphDataIterator;
      typedef FeatStd::Internal::Vector<Candera::TextRendering::TextPosition> CodePointMap;

      static SharedPointer Create(const Candera::TextRendering::TextRenderContext* reference);

      TruncateGlyphDataIterator GetTruncateGlyphDataIterator() const;

      FeatStd::Int GetTextWidth() const;

      void ApplyCodePointMap(const FeatStd::TChar* text);
      FeatStd::UInt32 GetCodePointIndex(Candera::TextRendering::TextPosition characterPosition) const;
      Candera::TextRendering::TextPosition GetCharacterPosition(FeatStd::UInt32 codePointIndex) const;

   private:

      DataContainer m_container;
      CodePointMap m_codePointMap;
      FeatStd::Int m_textWidth;

      TruncationTextContext(const Candera::TextRendering::TextRenderContext* reference);

      virtual void Measure(Candera::TextRendering::PixelPosition x, Candera::TextRendering::PixelPosition y,
                           const Candera::TextRendering::GlyphBitmap& glyph) override final;
      virtual ReferenceIterator* GetReferenceIterator() const override final;
};


inline
FeatStd::Int TruncationTextContext::GetTextWidth() const
{
   return m_textWidth;
}


inline
void TruncationTextContext::TruncateGlyphData::SetGlyphIndex(Candera::TextRendering::GlyphIndex index) const
{
   m_glyphIndex = index;
}


inline
Candera::TextRendering::GlyphIndex TruncationTextContext::TruncateGlyphData::GetGlyphIndex() const
{
   return m_glyphIndex;
}


inline
Candera::TextRendering::TextPosition TruncationTextContext::TruncateGlyphData::GetCharacterPosition() const
{
   return m_characterPosition;
}


inline
Candera::TextRendering::PixelPosition2D TruncationTextContext::TruncateGlyphData::GetPosition() const
{
   return m_position;
}


inline
Candera::TextRendering::FontIdentifier TruncationTextContext::TruncateGlyphData::GetFontIdentifier() const
{
   return m_fontIdentifier;
}


inline
Candera::TextRendering::PixelSize2D TruncationTextContext::TruncateGlyphData::GetAdvance() const
{
   return m_advance;
}


inline
Candera::TextRendering::TextRect TruncationTextContext::TruncateGlyphData::GetRect() const
{
   return m_rect;
}


inline
Candera::TextRendering::GlyphBitmap::Direction TruncationTextContext::TruncateGlyphData::GetDirection() const
{
   return m_direction;
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
