/* ***************************************************************************************
* FILE:          LiteHtmlDocFab.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  LiteHtmlDocFab is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

#include <Widgets/2D/RichText/DocumentFactory/RtAbstractFormattedDocFab.h>
#include <Widgets/2D/RichText/LiteHtml/LiteHtmlParser.h>

namespace hmibase {
namespace widget {
namespace richtext {

/**
  * Creates a rich text document based on an (X)HTML formatted text.
  */
class LiteHtmlDocFab : public AbstractFormattedDocFab
{
   public:
      FEATSTD_RTTI_DECLARATION();

      FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

      virtual void Prepare(Engine& engine) override;
      virtual Document::SharedPointer CreateDocument(Engine& engine) override;

   private:
      LiteHtmlParser m_parser;

      LiteHtmlDocFab();
};


inline
LiteHtmlDocFab::LiteHtmlDocFab()
{
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
