/* ***************************************************************************************
* FILE:          LiteHtmlDocFab.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  LiteHtmlDocFab is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "LiteHtmlDocFab.h"
#include <Widgets/2D/RichText/Utils/RtTextInStream.h>

namespace hmibase {
namespace widget {
namespace richtext {

FEATSTD_RTTI_DEFINITION(LiteHtmlDocFab, AbstractFormattedDocFab)


LiteHtmlDocFab::SharedPointer LiteHtmlDocFab::Create()
{
   return LiteHtmlDocFab::SharedPointer(FEATSTD_NEW(LiteHtmlDocFab));
}


void LiteHtmlDocFab::Prepare(Engine& engine)
{
   m_parser.CreateLiteHtmlDocAsync(engine);
}


Document::SharedPointer LiteHtmlDocFab::CreateDocument(Engine& engine)
{
   return m_parser.Parse(engine);
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
