/* ***************************************************************************************
* FILE:          RtMarker.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtMarker is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "RtMarker.h"

namespace hmibase {
namespace widget {
namespace richtext {

using FeatStd::UInt8;
using FeatStd::UInt16;
using FeatStd::UInt32;

FEATSTD_RTTI_DEFINITION(Marker, Base);

Marker::Marker() :
   Base(),
   m_markList()
{
   (void)m_markList.Reserve(4);
}


Marker::~Marker()
{
}


void Marker::Add(DocRange::SharedPointer mark)
{
   (void)m_markList.Add(mark);
}


void Marker::Remove(DocRange::SharedPointer mark)
{
   FeatStd::SizeType count = m_markList.Size();
   FeatStd::SizeType idx = 0;
   while ((idx < count) && (m_markList[idx] != mark))
   {
      idx++;
   }
   if (idx < count)
   {
      (void)m_markList.Remove(idx);
   }
}


DocRange::SharedPointer Marker::Remove(UInt32 index)
{
   DocRange::SharedPointer removedElem;
   if (index <  m_markList.Size())
   {
      removedElem = m_markList[index];
      (void)m_markList.Remove(index);
   }
   return removedElem;
}


UInt32 Marker::GetCount() const
{
   return m_markList.Size();
}


const Marker::MarkList& Marker::Get() const
{
   return m_markList;
}


DocRange::SharedPointer Marker::Get(UInt32 index)
{
   DocRange::SharedPointer elem;
   if (index < m_markList.Size())
   {
      elem = m_markList[index];
   }
   return elem;
}


void Marker::ClearAll()
{
   m_markList.Clear();
}


}
}


}
