/* ***************************************************************************************
* FILE:          RtEngine.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtEngine is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtEngine.h"
#include <Widgets/2D/RichText/Engine/Internal/RtEngineImpl.h>

namespace hmibase {
namespace widget {
namespace richtext {


FEATSTD_RTTI_BASECLASS_DEFINITION(Engine);

Engine::Engine()
{
}


Engine::~Engine()
{
}


Engine::SharedPointer Engine::Create()
{
   return Engine::SharedPointer(FEATSTD_NEW(EngineImpl));
}


void Engine::SetData(const Data& data)
{
   m_data = data;

   RichTextRenderer::SharedPointer renderer = GetRenderer();
   if (renderer != 0)
   {
      renderer->Invalidate();
   }
}


Engine::Data::Data() :
   m_colorEnabled(false),
   m_horizontalAlignmentEnabled(false),
   m_asynchronousRendering(false),
   m_slicedRendering(false),
   m_cultureDependentAlignment(true),
   m_maxNumberOfLines(0),
   m_sliceHeight(0),
   m_baselineOffset(-1),
   m_markup(Markup::Invalid),
   m_horizontalAlignment(Candera::HLeft),
   m_view(0)
{
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
