/* ***************************************************************************************
* FILE:          RtDynamicProperties.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtDynamicProperties is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#pragma once

#include <Candera/EngineBase/DynamicProperties/DynamicProperty.h>
#include <Candera/EngineBase/DataTypes/CanderaObjectDataType.h>

namespace Candera {
class CanderaObject;
}


namespace hmibase {
namespace widget {
namespace richtext {

class Engine;

class DynamicProperties
{
   public:
      static void ClearMarqueeEnabled(Candera::CanderaObject* node);
      static bool IsMarqueeEnabled(const Candera::CanderaObject* node);
      static void SetMarqueeEnabled(Candera::CanderaObject* node, bool marqueeEnabled);

      static void ClearEngine(Candera::CanderaObject* node);
      static Engine* GetEngine(const Candera::CanderaObject* node);
      static void SetEngine(Candera::CanderaObject* node, Engine* engine);

      static const Candera::DynamicProperties::DynamicPropertyHost* ParentProvider(const Candera::DynamicProperties::DynamicPropertyHost* host);

   private:
      CdaDynamicPropertiesDefinition(DynamicProperties, Candera::DynamicProperties::DynamicPropertyHost);

      CdaDynamicProperty(Engine, Engine*);
      CdaDynamicPropertyDefaultValue(0);
      CdaDynamicPropertyEnd();

      CdaDynamicProperty(MarqueeEnabled, bool);
      CdaDynamicPropertyDefaultValue(false);
      CdaDynamicPropertyEnd();

      CdaDynamicPropertiesEnd();
};


inline
const Candera::DynamicProperties::DynamicPropertyHost* DynamicProperties::ParentProvider(const
      Candera::DynamicProperties::DynamicPropertyHost* /*host*/)
{
   return 0;
}


}
}


}
