/* ***************************************************************************************
* FILE:          RtDocRange.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtHighlighter is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtDocRange.h"

namespace hmibase {
namespace widget {
namespace richtext {

using FeatStd::UInt8;
using FeatStd::UInt16;
using FeatStd::UInt32;

FEATSTD_RTTI_BASECLASS_DEFINITION(DocRange);


DocRange::DocRange() :
   m_elems(),
   m_start(0),
   m_end(0),
   m_visibility(true)
{
}


DocRange::~DocRange()
{
}


UInt32 DocRange::GetStart() const
{
   return m_start;
}


UInt32 DocRange::GetEnd() const
{
   return m_end;
}


const DocRange::DocElemList& DocRange::GetElements() const
{
   return m_elems;
}


void DocRange::SetVisibility(bool show)
{
   m_visibility = show;
}


bool DocRange::GetVisibility() const
{
   return m_visibility;
}


void DocRange::SetStart(UInt32 start)
{
   m_start = start;
}


void DocRange::SetEnd(UInt32 end)
{
   m_end = end;
}


void DocRange::AddElement(const DocElement::SharedPointer& element)
{
   (void)m_elems.Add(element);
}


void DocRange::ClearRange()
{
   m_elems.Clear();
}


}
}


}
