/* ***************************************************************************************
* FILE:          RtViewportImpl.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtViewportImpl is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtViewportImpl.h"
#include <Widgets/2D/RichText/Engine/RtEngine.h>

namespace hmibase {
namespace widget {
namespace richtext {

using FeatStd::UInt8;
using FeatStd::UInt16;
using FeatStd::UInt32;
using FeatStd::Float;
using Candera::Vector2;

FEATSTD_RTTI_DEFINITION(ViewportImpl, Base);

ViewportImpl::SharedPointer ViewportImpl::Create(Engine* engine)
{
   ViewportImpl::SharedPointer sp = ViewportImpl::SharedPointer(FEATSTD_NEW(ViewportImpl));
   if (!sp.PointsToNull())
   {
      sp->AttachEngine(engine);
   }
   return sp;
}


ViewportImpl::ViewportImpl() :
   Base(),
   m_renderingEnabled(true)
{
}


ViewportImpl::~ViewportImpl()
{
}


void ViewportImpl::EnableRendering(bool enable)
{
   if (m_renderingEnabled != enable)
   {
      m_renderingEnabled = enable;
   }
}


bool ViewportImpl::IsRenderingEnabled() const
{
   return m_renderingEnabled;
}


void ViewportImpl::SetSize(const Vector2& size)
{
   if (m_size != size)
   {
      m_size = size;
      if ((0 != GetEngine()) && (!GetEngine()->GetRenderer().PointsToNull()))
      {
         GetEngine()->GetRenderer()->SetSize(static_cast<UInt16>(m_size.GetX()), static_cast<UInt16>(m_size.GetY()));
      }
   }
}


const Vector2& ViewportImpl::GetSize() const
{
   _TODO("Proper implementation missing -> Sync with renderer");
   return m_size;
}


void ViewportImpl::SetScaleFactor(Float /*scaleX*/, Float /*scaleY*/)
{
   _TODO("Proper implementation missing");
}


void ViewportImpl::SetScaleFactor(const Vector2& /*scaleFactor*/)
{
   _TODO("Proper implementation missing");
}


Vector2 ViewportImpl::GetScaleFactor() const
{
   _TODO("Proper implementation missing");
   return  Vector2(1.0F, 1.0F);
}


Vector2 ViewportImpl::ToDocumentPosition(const Vector2& screenPosition) const
{
   _TODO("Proper implementation missing");
   return  screenPosition;
}


Vector2 ViewportImpl::ToViewportPosition(const Vector2& documentPosition) const
{
   _TODO("Proper implementation missing");
   return  documentPosition;
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
