/* ***************************************************************************************
* FILE:          RtEngineImpl.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RtEngineImpl is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "RtEngineImpl.h"
#include <FeatStd/Util/StaticObject.h>
#include <Widgets/2D/RichText/DocumentFactory/RtDocumentFab.h>
#include <Widgets/2D/RichText/Utils/RtStringInStream.h>

namespace hmibase {
namespace widget {
namespace richtext {

using FeatStd::UInt16;
using FeatStd::UInt32;
using FeatStd::Float;
using Candera::Vector2;

FEATSTD_RTTI_DEFINITION(EngineImpl, Base);

EngineImpl::EngineImpl() :
   Base(),
   m_viewport(),
   m_docAccessor(),
   m_caretBasedDocManipulator()
{
}


EngineImpl::~EngineImpl()
{
   if (!m_docAccessor.PointsToNull())
   {
      m_docAccessor->DetachEngine();
   }
   if (!m_caretBasedDocManipulator.PointsToNull())
   {
      m_caretBasedDocManipulator->DetachEngine();
   }
   if (!m_viewport.PointsToNull())
   {
      m_viewport->DetachEngine();
   }
}


void EngineImpl::PrepareDocument()
{
   DocumentFab::GetInstance().Prepare(*this);
}


void EngineImpl::CreateDocument()
{
   if (!GetDocAccessor().PointsToNull())
   {
      Document::SharedPointer document = DocumentFab::GetInstance().CreateDocument(*this);
      GetDocAccessorImpl()->SetDocument(GetData().m_markup, document);

      Highlighter::SharedPointer highlighter = GetHighlighter();
      if (highlighter != 0)
      {
         highlighter->Update();
      }
   }
}


DocAccessorImpl::SharedPointer EngineImpl::GetDocAccessorImpl()
{
   if (m_docAccessor.PointsToNull())
   {
      m_docAccessor = DocAccessorImpl::Create(this);
   }
   return m_docAccessor;
}


CaretBasedDocManipulatorImpl::SharedPointer EngineImpl::GetCaretBasedDocManipulatorImpl()
{
   if (m_caretBasedDocManipulator.PointsToNull())
   {
      m_caretBasedDocManipulator = CaretBasedDocManipulatorImpl::Create(this);
   }
   return m_caretBasedDocManipulator;
}


ViewportImpl::SharedPointer EngineImpl::GetViewportImpl()
{
   if (m_viewport.PointsToNull())
   {
      m_viewport = ViewportImpl::Create(this);
   }
   return m_viewport;
}


RichTextRenderer::SharedPointer EngineImpl::GetRenderer()
{
   if (m_renderer.PointsToNull())
   {
      m_renderer = RichTextRenderer::Create(this);
   }
   return m_renderer;
}


Highlighter::SharedPointer EngineImpl::GetHighlighter()
{
   return m_highlighter;
}


void EngineImpl::SetHighlighter()
{
   if (m_highlighter.PointsToNull())
   {
      m_highlighter = HighlighterImpl::Create(this);
   }
}


void EngineImpl::Render()
{
   RichTextRenderer::SharedPointer renderer = GetRenderer();
   DocAccessorImpl::SharedPointer docAccessor = GetDocAccessorImpl();
   if ((renderer != 0) && (docAccessor != 0))
   {
      renderer->Render();
   }
}


} // namespace richtext
} // namespace widget
} // namespace hmibase
